/*
 * Decompiled with CFR 0.152.
 */
package com.stratumn.chainscript;

import com.google.protobuf.ByteString;
import com.stratumn.chainscript.ChainscriptException;
import com.stratumn.chainscript.Constants;
import com.stratumn.chainscript.Error;
import com.stratumn.chainscript.Link;
import com.stratumn.chainscript.utils.CryptoUtils;
import com.stratumn.chainscript.utils.JsonHelper;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import org.apache.commons.lang3.StringUtils;
import stratumn.chainscript.Chainscript;

public class Signature {
    private Chainscript.Signature signature;

    public Signature(Chainscript.Signature signature) {
        this.signature = signature;
    }

    public String version() {
        return StringUtils.isEmpty((CharSequence)this.signature.getVersion()) ? "" : this.signature.getVersion();
    }

    public String type() {
        return StringUtils.isEmpty((CharSequence)this.signature.getType()) ? "" : this.signature.getType();
    }

    public String payloadPath() {
        return StringUtils.isEmpty((CharSequence)this.signature.getPayloadPath()) ? "" : this.signature.getPayloadPath();
    }

    public byte[] publicKey() {
        return (this.signature.getPublicKey() != null ? this.signature.getPublicKey() : ByteString.EMPTY).toByteArray();
    }

    public byte[] signature() {
        return (this.signature.getSignature() != null ? this.signature.getSignature() : ByteString.EMPTY).toByteArray();
    }

    public void validate(Link link) throws ChainscriptException {
        if (this.publicKey() == null || this.publicKey().length == 0) {
            throw new ChainscriptException(Error.SignaturePublicKeyMissing);
        }
        if (this.signature() == null || this.signature().length == 0) {
            throw new ChainscriptException(Error.SignatureMissing);
        }
        switch (this.version()) {
            case "1.0.0": {
                byte[] signed = link.signedBytes(this.version(), this.payloadPath());
                String publicKeyString = new String(this.publicKey(), Constants.UTF8);
                try {
                    PublicKey publicKey = CryptoUtils.decodePublicKey(publicKeyString);
                    if (!CryptoUtils.verify(publicKey, signed, new String(this.signature()))) {
                        throw new ChainscriptException(Error.SignatureInvalid);
                    }
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
                    throw new ChainscriptException(e);
                }
                return;
            }
        }
        throw new ChainscriptException(Error.SignatureVersionUnknown);
    }

    public static Signature sign(byte[] key, byte[] toSign) throws ChainscriptException {
        PublicKey publicKey = null;
        Chainscript.Signature sig = null;
        try {
            PrivateKey privateKey = CryptoUtils.decodePrivateKey(key);
            String signedMessage = CryptoUtils.sign(privateKey, toSign);
            publicKey = CryptoUtils.getPublicKeyFromPrivateKey(privateKey);
            sig = Chainscript.Signature.newBuilder().setVersion("1.0.0").setSignature(ByteString.copyFrom((byte[])signedMessage.getBytes())).setPublicKey(ByteString.copyFrom((byte[])CryptoUtils.encodePublicKey(publicKey).getBytes())).build();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new ChainscriptException("Could not create the private key / signature", e);
        }
        return new Signature(sig);
    }

    public static Signature signLink(byte[] key, Link link, String payloadPath) throws ChainscriptException {
        if (StringUtils.isEmpty((CharSequence)payloadPath)) {
            payloadPath = "[version,data,meta]";
        }
        byte[] toSign = link.signedBytes("1.0.0", payloadPath);
        Signature signature = Signature.sign(key, toSign);
        Chainscript.Signature sig = Chainscript.Signature.newBuilder().setVersion(signature.version()).setPayloadPath(payloadPath).setPublicKey(ByteString.copyFrom((byte[])signature.publicKey())).setSignature(ByteString.copyFrom((byte[])signature.signature())).build();
        return new Signature(sig);
    }

    public String toObject() throws ChainscriptException {
        try {
            return JsonHelper.toJson(this.signature);
        }
        catch (IOException e) {
            throw new ChainscriptException(e);
        }
    }

    public static Signature fromObject(String jsonObject) {
        return new Signature(JsonHelper.fromJson(jsonObject, Chainscript.Signature.class));
    }
}

