/*
 * Decompiled with CFR 0.152.
 */
package com.stratumn.chainscript;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.stratumn.chainscript.ChainscriptException;
import com.stratumn.chainscript.Error;
import com.stratumn.chainscript.utils.JsonHelper;
import org.apache.commons.lang3.StringUtils;
import stratumn.chainscript.Chainscript;

public class Evidence {
    private String version;
    private String backend;
    private String provider;
    private byte[] proof;

    public Evidence(String version, String backend, String provider, byte[] proof) throws ChainscriptException {
        this.version = version;
        this.backend = backend;
        this.provider = provider;
        this.proof = proof;
        this.validate();
    }

    public void validate() throws ChainscriptException {
        if (StringUtils.isEmpty((CharSequence)this.version)) {
            throw new ChainscriptException(Error.EvidenceVersionMissing);
        }
        if (StringUtils.isEmpty((CharSequence)this.backend)) {
            throw new ChainscriptException(Error.EvidenceBackendMissing);
        }
        if (StringUtils.isEmpty((CharSequence)this.provider)) {
            throw new ChainscriptException(Error.EvidenceProviderMissing);
        }
        if (this.proof == null || this.proof.length == 0) {
            throw new ChainscriptException(Error.EvidenceProofMissing);
        }
    }

    public byte[] serialize() {
        return Chainscript.Evidence.newBuilder().setVersion(this.version).setBackend(this.backend).setProvider(this.provider).setProof(ByteString.copyFrom((byte[])this.proof)).build().toByteArray();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public byte[] getProof() {
        return this.proof;
    }

    public void setProof(byte[] proof) {
        this.proof = proof;
    }

    public String toObject() {
        return JsonHelper.toJson(this.toProto());
    }

    public static Evidence fromObject(String jsonObject) throws ChainscriptException {
        Chainscript.Evidence e = JsonHelper.fromJson(jsonObject, Chainscript.Evidence.class);
        return Evidence.fromProto(e);
    }

    public static Evidence fromProto(Chainscript.Evidence object) throws ChainscriptException {
        String version = StringUtils.isEmpty((CharSequence)object.getVersion()) ? "" : object.getVersion();
        String backend = StringUtils.isEmpty((CharSequence)object.getBackend()) ? "" : object.getBackend();
        String provider = StringUtils.isEmpty((CharSequence)object.getProvider()) ? "" : object.getProvider();
        byte[] proof = object.getProof() != null ? object.getProof().toByteArray() : new byte[]{};
        return new Evidence(version, backend, provider, proof);
    }

    public Chainscript.Evidence toProto() {
        return Chainscript.Evidence.newBuilder().setBackend(this.backend).setVersion(this.getVersion()).setProvider(this.provider).setProof(ByteString.copyFrom((byte[])this.proof)).build();
    }

    public static Evidence deserialize(byte[] evidenceBytes) throws ChainscriptException {
        Chainscript.Evidence pbEvidence;
        try {
            pbEvidence = Chainscript.Evidence.parseFrom(evidenceBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ChainscriptException(e);
        }
        return Evidence.fromProto(pbEvidence);
    }
}

