/*
 * Decompiled with CFR 0.152.
 */
package com.stratumn.chainscript;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.stratumn.canonicaljson.CanonicalJson;
import com.stratumn.chainscript.ChainscriptException;
import com.stratumn.chainscript.Constants;
import com.stratumn.chainscript.Error;
import com.stratumn.chainscript.LinkReference;
import com.stratumn.chainscript.Process;
import com.stratumn.chainscript.Segment;
import com.stratumn.chainscript.Signature;
import com.stratumn.chainscript.utils.CryptoUtils;
import com.stratumn.chainscript.utils.JsonHelper;
import io.burt.jmespath.Expression;
import io.burt.jmespath.gson.GsonRuntime;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import stratumn.chainscript.Chainscript;

public class Link {
    private Chainscript.Link link;

    public Link(Chainscript.Link link) {
        this.link = link;
    }

    public String action() throws ChainscriptException {
        return this.getLinkMeta().getAction() == null ? "" : this.getLinkMeta().getAction();
    }

    public void addSignature(Signature signature) throws ChainscriptException {
        signature.validate(this);
        Chainscript.Signature sig = Chainscript.Signature.newBuilder().setVersion(signature.version()).setPayloadPath(signature.payloadPath()).setPublicKey(ByteString.copyFrom((byte[])signature.publicKey())).setSignature(ByteString.copyFrom((byte[])signature.signature())).build();
        this.link.getSignaturesList().add(sig);
    }

    public String clientId() throws ChainscriptException {
        return this.getLinkMeta().getClientId() == null ? "" : this.getLinkMeta().getClientId();
    }

    public Object data() throws ChainscriptException {
        this.verifyCompatibility();
        if (this.link.getData() == null || this.link.getData().isEmpty()) {
            return null;
        }
        switch (this.version()) {
            case "1.0.0": {
                try {
                    return CanonicalJson.parse((String)this.link.getData().toStringUtf8());
                }
                catch (IOException e) {
                    throw new ChainscriptException("Failed to parse link data");
                }
            }
        }
        throw new ChainscriptException(Error.LinkVersionUnknown);
    }

    public <T> T data(Class<T> clazzOfT) throws ChainscriptException {
        this.verifyCompatibility();
        if (this.link.getData() == null || this.link.getData().isEmpty()) {
            return null;
        }
        switch (this.version()) {
            case "1.0.0": {
                return JsonHelper.fromJson(this.link.getData().toStringUtf8(), clazzOfT);
            }
        }
        throw new ChainscriptException(Error.LinkVersionUnknown);
    }

    public byte[] hash() throws ChainscriptException {
        switch (this.version()) {
            case "1.0.0": {
                byte[] linkBytes = this.link.toByteArray();
                return CryptoUtils.sha256(linkBytes);
            }
        }
        throw new ChainscriptException(Error.LinkVersionUnknown);
    }

    public String mapId() throws ChainscriptException {
        Chainscript.LinkMeta meta = this.getLinkMeta();
        return StringUtils.isEmpty((CharSequence)meta.getMapId()) ? "" : meta.getMapId();
    }

    public Object metadata() throws ChainscriptException {
        this.verifyCompatibility();
        Object result = null;
        ByteString linkMetadata = this.getLinkMeta().getData();
        if (linkMetadata == null || linkMetadata.isEmpty()) {
            return result;
        }
        switch (this.version()) {
            case "1.0.0": {
                try {
                    return CanonicalJson.parse((String)linkMetadata.toStringUtf8());
                }
                catch (IOException e) {
                    throw new ChainscriptException("Failed to parse link Metadata");
                }
            }
        }
        throw new ChainscriptException(Error.LinkVersionUnknown);
    }

    public <T> T metadata(Class<T> clazzOfT) throws ChainscriptException {
        this.verifyCompatibility();
        ByteString linkMetadata = this.getLinkMeta().getData();
        if (linkMetadata == null || linkMetadata.isEmpty()) {
            return null;
        }
        switch (this.version()) {
            case "1.0.0": {
                return JsonHelper.fromJson(linkMetadata.toStringUtf8(), clazzOfT);
            }
        }
        throw new ChainscriptException(Error.LinkVersionUnknown);
    }

    public int outDegree() throws ChainscriptException {
        return this.getLinkMeta().getOutDegree();
    }

    public byte[] prevLinkHash() throws ChainscriptException {
        if (this.getLinkMeta().getPrevLinkHash() == null) {
            return new byte[0];
        }
        return this.getLinkMeta().getPrevLinkHash().toByteArray();
    }

    public double priority() throws ChainscriptException {
        return this.getLinkMeta().getPriority();
    }

    public Process process() throws ChainscriptException {
        Chainscript.Process process = this.getLinkMeta().getProcess();
        if (process == null) {
            throw new ChainscriptException(Error.LinkProcessMissing);
        }
        return new Process(StringUtils.isEmpty((CharSequence)process.getName()) ? "" : process.getName(), StringUtils.isEmpty((CharSequence)process.getState()) ? "" : process.getState());
    }

    public LinkReference[] refs() throws ChainscriptException {
        List<Chainscript.LinkReference> refList = this.getLinkMeta().getRefsList();
        if (refList == null) {
            return new LinkReference[0];
        }
        ArrayList<LinkReference> refListOut = new ArrayList<LinkReference>();
        for (Chainscript.LinkReference ref : refList) {
            LinkReference linkReference = new LinkReference(ref.getLinkHash() != null ? ref.getLinkHash().toByteArray() : new byte[]{}, ref.getProcess() != null ? ref.getProcess() : "");
            refListOut.add(linkReference);
        }
        return refListOut.toArray(new LinkReference[refListOut.size()]);
    }

    public Segment segmentify() throws ChainscriptException {
        Chainscript.Segment segment = Chainscript.Segment.newBuilder().setLink(this.link).build();
        return new Segment(segment);
    }

    public byte[] serialize() {
        return this.link.toByteArray();
    }

    public void setData(Object data) throws ChainscriptException {
        this.verifyCompatibility();
        switch (this.version()) {
            case "1.0.0": {
                try {
                    String canonicalData = CanonicalJson.stringify((Object)data);
                    this.link = this.link.toBuilder().setData(ByteString.copyFrom((String)canonicalData, (Charset)Constants.UTF8)).build();
                    return;
                }
                catch (Exception e) {
                    throw new ChainscriptException(e);
                }
            }
        }
        throw new ChainscriptException(Error.LinkVersionUnknown);
    }

    public void setMetadata(Object data) throws ChainscriptException {
        this.verifyCompatibility();
        switch (this.version()) {
            case "1.0.0": {
                try {
                    String canonicalData = CanonicalJson.stringify((Object)data);
                    Chainscript.LinkMeta meta = this.getLinkMeta().toBuilder().setData(ByteString.copyFromUtf8((String)canonicalData)).build();
                    this.link = this.link.toBuilder().setMeta(meta).build();
                    return;
                }
                catch (Exception e) {
                    throw new ChainscriptException(e);
                }
            }
        }
        throw new ChainscriptException(Error.LinkVersionUnknown);
    }

    public void sign(byte[] key, String payloadPath) throws ChainscriptException {
        Signature signature = Signature.signLink(key, this, payloadPath);
        Chainscript.Signature sig = Chainscript.Signature.newBuilder().setVersion(signature.version()).setPayloadPath(signature.payloadPath()).setPublicKey(ByteString.copyFrom((byte[])signature.publicKey())).setSignature(ByteString.copyFrom((byte[])signature.signature())).build();
        this.link = this.link.toBuilder().addSignatures(sig).build();
    }

    public Signature[] signatures() {
        Signature[] signatures = new Signature[this.link.getSignaturesList().size()];
        for (int i = 0; i < this.link.getSignaturesList().size(); ++i) {
            Signature signature;
            signatures[i] = signature = new Signature(this.link.getSignatures(i));
        }
        return signatures;
    }

    public byte[] signedBytes(String version, String payloadPath) throws ChainscriptException {
        byte[] hashedResultBytes = null;
        switch (version) {
            case "1.0.0": {
                if (StringUtils.isEmpty((CharSequence)payloadPath)) {
                    payloadPath = "[version,data,meta]";
                }
                String linkJson = null;
                try {
                    GsonRuntime jmespath = new GsonRuntime();
                    Expression expression = jmespath.compile(payloadPath);
                    linkJson = JsonFormat.printer().print((MessageOrBuilder)this.link);
                    JsonElement payloadPathJson = new JsonParser().parse(linkJson);
                    JsonElement result = (JsonElement)expression.search((Object)payloadPathJson);
                    String canonicalResult = CanonicalJson.canonizalize((String)result.toString());
                    byte[] payloadBytes = canonicalResult.getBytes(StandardCharsets.UTF_8);
                    hashedResultBytes = CryptoUtils.sha256(payloadBytes);
                    break;
                }
                catch (IOException e1) {
                    throw new ChainscriptException(e1);
                }
            }
            default: {
                throw new ChainscriptException(Error.SignatureVersionUnknown);
            }
        }
        return hashedResultBytes;
    }

    public String step() throws ChainscriptException {
        return StringUtils.isEmpty((CharSequence)this.getLinkMeta().getStep()) ? "" : this.getLinkMeta().getStep();
    }

    public String[] tags() throws ChainscriptException {
        String[] result = this.getLinkMeta().getTagsList() != null ? (String[])this.getLinkMeta().getTagsList().toArray((Object[])new String[this.getLinkMeta().getTagsList().size()]) : new String[]{};
        return result;
    }

    public void validate() throws ChainscriptException {
        if (StringUtils.isEmpty((CharSequence)this.link.getVersion())) {
            throw new ChainscriptException(Error.LinkVersionMissing);
        }
        Chainscript.LinkMeta meta = this.getLinkMeta();
        if (StringUtils.isEmpty((CharSequence)meta.getMapId())) {
            throw new ChainscriptException(Error.LinkMapIdMissing);
        }
        if (meta.getProcess() == null || StringUtils.isEmpty((CharSequence)meta.getProcess().getName())) {
            throw new ChainscriptException(Error.LinkProcessMissing);
        }
        this.verifyCompatibility();
        for (LinkReference ref : this.refs()) {
            if (StringUtils.isEmpty((CharSequence)ref.getProcess())) {
                throw new ChainscriptException(Error.LinkProcessMissing);
            }
            if (ref.getLinkHash() != null && ref.getLinkHash().length != 0) continue;
            throw new ChainscriptException(Error.LinkHashMissing);
        }
        for (Signature sig : this.signatures()) {
            sig.validate(this);
        }
    }

    public String version() {
        return this.link.getVersion();
    }

    private void verifyCompatibility() throws ChainscriptException {
        if (StringUtils.isEmpty((CharSequence)this.getLinkMeta().getClientId())) {
            throw new ChainscriptException(Error.LinkClientIdUnkown);
        }
        if (!Arrays.asList(Constants.COMPATIBLE_CLIENTS).contains(this.getLinkMeta().getClientId())) {
            throw new ChainscriptException(Error.LinkClientIdUnkown);
        }
    }

    public Chainscript.Link getLink() {
        return this.link;
    }

    private Chainscript.LinkMeta getLinkMeta() throws ChainscriptException {
        if (this.link.getMeta() == null) {
            throw new ChainscriptException(Error.LinkMetaMissing);
        }
        return this.link.getMeta();
    }

    public String toObject() {
        return JsonHelper.toJson(this.link);
    }

    public static Link fromObject(String jsonObject) {
        return new Link(JsonHelper.fromJson(jsonObject, Chainscript.Link.class));
    }

    public static Link deserialize(byte[] linkBytes) throws ChainscriptException {
        try {
            return new Link(Chainscript.Link.parseFrom(linkBytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new ChainscriptException(e);
        }
    }
}

