/*
 * Decompiled with CFR 0.152.
 */
package com.stratumn.chainscript;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.stratumn.chainscript.ChainscriptException;
import com.stratumn.chainscript.Error;
import com.stratumn.chainscript.Evidence;
import com.stratumn.chainscript.Link;
import com.stratumn.chainscript.utils.JsonHelper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import stratumn.chainscript.Chainscript;

public class Segment {
    private Chainscript.Link pbLink;
    private Chainscript.Segment pbSegment;

    public Segment(Chainscript.Segment pbSegment) throws ChainscriptException {
        if (!pbSegment.hasLink()) {
            throw new ChainscriptException(Error.LinkMissing);
        }
        this.pbLink = pbSegment.getLink();
        this.pbSegment = pbSegment;
        if (pbSegment.getMeta() == null) {
            this.pbSegment = this.pbSegment.toBuilder().setMeta(Chainscript.SegmentMeta.getDefaultInstance()).build();
        }
        Link link = new Link(this.pbLink);
        Chainscript.SegmentMeta segmentMeta = this.pbSegment.getMeta().toBuilder().setLinkHash(ByteString.copyFrom((byte[])link.hash())).build();
        this.pbSegment = this.pbSegment.toBuilder().setMeta(segmentMeta).build();
    }

    public void addEvidence(Evidence e) throws ChainscriptException {
        e.validate();
        if (this.getEvidence(e.getBackend(), e.getProvider()) != null) {
            throw new ChainscriptException(Error.DuplicateEvidence);
        }
        Chainscript.Evidence pbEvidence = Chainscript.Evidence.newBuilder().setVersion(e.getVersion()).setBackend(e.getBackend()).setProvider(e.getProvider()).setProof(ByteString.copyFrom((byte[])e.getProof())).build();
        this.pbSegment = this.pbSegment.toBuilder().setMeta(this.pbSegment.getMeta().toBuilder().addEvidences(pbEvidence).build()).build();
    }

    public Evidence[] evidences() throws ChainscriptException {
        List<Chainscript.Evidence> evidences = this.pbSegment.getMeta().getEvidencesList();
        ArrayList<Evidence> result = new ArrayList<Evidence>();
        for (Chainscript.Evidence evidence : evidences) {
            result.add(Evidence.fromProto(evidence));
        }
        return result.toArray(new Evidence[result.size()]);
    }

    public Evidence[] findEvidences(String backend) throws ChainscriptException {
        List<Chainscript.Evidence> evidences = this.pbSegment.getMeta().getEvidencesList();
        ArrayList<Evidence> result = new ArrayList<Evidence>();
        for (Chainscript.Evidence evidence : evidences) {
            if (!evidence.getBackend().equals(backend)) continue;
            result.add(Evidence.fromProto(evidence));
        }
        return result.toArray(new Evidence[result.size()]);
    }

    public Evidence getEvidence(String backend, String provider) throws ChainscriptException {
        List<Chainscript.Evidence> evidences = this.pbSegment.getMeta().getEvidencesList();
        for (Chainscript.Evidence evidence : evidences) {
            if (!evidence.getBackend().equals(backend) || !evidence.getProvider().equals(provider)) continue;
            return Evidence.fromProto(evidence);
        }
        return null;
    }

    public Link link() {
        return new Link(this.pbLink);
    }

    public byte[] linkHash() {
        return this.pbSegment.getMeta().getLinkHash().toByteArray();
    }

    public byte[] serialize() {
        return Chainscript.Segment.newBuilder(this.pbSegment).build().toByteArray();
    }

    public void validate() throws ChainscriptException {
        if (!this.pbSegment.hasMeta()) {
            throw new ChainscriptException(Error.SegmentMetaMissing);
        }
        if (this.linkHash() == null || this.linkHash().length == 0) {
            throw new ChainscriptException(Error.LinkHashMissing);
        }
        if (!Base64.getEncoder().encodeToString(this.linkHash()).equals(Base64.getEncoder().encodeToString(this.link().hash()))) {
            throw new ChainscriptException(Error.LinkHashMismatch);
        }
        this.link().validate();
    }

    public String toObject() throws ChainscriptException {
        return JsonHelper.toJson(this.pbSegment);
    }

    public static Segment fromObject(String jsonObject) throws ChainscriptException {
        return new Segment(JsonHelper.fromJson(jsonObject, Chainscript.Segment.class));
    }

    public static Segment deserialize(byte[] segmentBytes) throws ChainscriptException {
        Chainscript.Segment segment;
        try {
            segment = Chainscript.Segment.parseFrom(segmentBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ChainscriptException("Failed to parse segment.");
        }
        return new Segment(segment);
    }
}

