/*
 * Decompiled with CFR 0.152.
 */
package com.stratumn.chainscript.utils;

import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class ProtoGsonAdapter<T extends Message>
extends TypeAdapter<T> {
    Class<T> messageClass;

    public ProtoGsonAdapter(Class<T> messageClass) {
        this.messageClass = messageClass;
    }

    public T read(JsonReader jsonReader) throws IOException {
        try {
            Message.Builder messageBuilder = (Message.Builder)this.messageClass.getDeclaredMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            JsonParser jsonParser = new JsonParser();
            JsonFormat.parser().merge(jsonParser.parse(jsonReader).toString(), messageBuilder);
            return (T)messageBuilder.build();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public void write(JsonWriter jsonWriter, T message) throws IOException {
        jsonWriter.jsonValue(JsonFormat.printer().print(message));
    }
}

