/*
 * Decompiled with CFR 0.152.
 */
package com.stratumn.chainscript.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stratumn.canonicaljson.CanonicalJson;
import com.stratumn.chainscript.utils.ProtoGsonAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stratumn.chainscript.Chainscript;

public class JsonHelper {
    private static GsonBuilder gsonBuilder;
    private static final Pattern indexPattern;

    private static GsonBuilder getGsonBuilder() {
        if (gsonBuilder == null) {
            gsonBuilder = new GsonBuilder().registerTypeAdapter(Chainscript.Link.class, new ProtoGsonAdapter<Chainscript.Link>(Chainscript.Link.class)).registerTypeAdapter(Chainscript.Segment.class, new ProtoGsonAdapter<Chainscript.Segment>(Chainscript.Segment.class)).registerTypeAdapter(Chainscript.Signature.class, new ProtoGsonAdapter<Chainscript.Signature>(Chainscript.Signature.class)).registerTypeAdapter(Chainscript.Evidence.class, new ProtoGsonAdapter<Chainscript.Evidence>(Chainscript.Evidence.class));
            gsonBuilder.serializeNulls().disableHtmlEscaping();
        }
        return gsonBuilder;
    }

    public static Gson getGson() {
        return JsonHelper.getGsonBuilder().create();
    }

    public static void registerTypeAdapter(Type type, Object typeAdapter) {
        JsonHelper.getGsonBuilder().registerTypeAdapter(type, typeAdapter);
    }

    public static void registerTypeHierarchyAdapter(Class<?> clazz, Object typeAdapter) {
        JsonHelper.getGsonBuilder().registerTypeHierarchyAdapter(clazz, typeAdapter);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)JsonHelper.getGson().fromJson(json, classOfT);
    }

    public static <T> T fromJson(JsonElement json, Class<T> typeOfT) {
        return (T)JsonHelper.getGson().fromJson(json, typeOfT);
    }

    public static String toCanonicalJson(Object src) throws IOException {
        String json = JsonHelper.getGson().toJson(src);
        return CanonicalJson.canonizalize((String)json);
    }

    public static Map<String, Object> objectToMap(Object srcObject) {
        return JsonHelper.objectToObject(srcObject, Map.class);
    }

    public static <T> T mapToObject(Map<String, Object> srcMap, Class<T> tClass) {
        String json = JsonHelper.getGson().toJson(srcMap);
        Object tObject = JsonHelper.getGson().fromJson(json, tClass);
        return (T)tObject;
    }

    public static <T> T objectToObject(Object srcObj, Class<T> tClass) {
        Object value = null;
        if (srcObj == null) {
            return null;
        }
        if (tClass.isAssignableFrom(srcObj.getClass())) {
            value = srcObj;
        } else {
            String json = srcObj instanceof JsonObject || srcObj instanceof String ? srcObj.toString() : JsonHelper.toJson(srcObj);
            value = JsonHelper.fromJson(json, tClass);
        }
        return (T)value;
    }

    public static String toJson(Object src) {
        String json = JsonHelper.getGson().toJson(src);
        return json;
    }

    public static JsonElement getData(JsonElement data, String path) {
        int firstSep = path.indexOf(46);
        String nextKey = firstSep == -1 ? path : path.substring(0, firstSep);
        int arrIndex = -1;
        if ((data = data.getAsJsonObject().get(nextKey)).isJsonNull()) {
            return null;
        }
        Matcher indexMatcher = indexPattern.matcher(nextKey);
        if (indexMatcher.find() && (arrIndex = Integer.parseInt(indexMatcher.group(1))) >= 0 && data.isJsonArray()) {
            data = data.getAsJsonArray().get(arrIndex);
        }
        if (firstSep != -1) {
            path = path.substring(firstSep + 1);
            data = JsonHelper.getData(data, path);
        }
        return data;
    }

    static {
        indexPattern = Pattern.compile("\\[(\\d+)\\]");
    }
}

