/*
 * Decompiled with CFR 0.152.
 */
package com.stratumn.chainscript;

import com.google.protobuf.ByteString;
import com.stratumn.chainscript.ChainscriptException;
import com.stratumn.chainscript.Error;
import com.stratumn.chainscript.ILinkBuilder;
import com.stratumn.chainscript.Link;
import com.stratumn.chainscript.LinkReference;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import stratumn.chainscript.Chainscript;

public class LinkBuilder
implements ILinkBuilder<LinkBuilder> {
    private Chainscript.Link link;
    private Object linkData;
    private Object linkMetadata;

    public LinkBuilder(String process, String mapId) throws ChainscriptException {
        if (StringUtils.isEmpty((CharSequence)process)) {
            throw new ChainscriptException(Error.LinkProcessMissing);
        }
        if (StringUtils.isEmpty((CharSequence)mapId)) {
            throw new ChainscriptException(Error.LinkMapIdMissing);
        }
        Chainscript.Process processObj = Chainscript.Process.newBuilder().setName(process).build();
        Chainscript.LinkMeta linkMeta = Chainscript.LinkMeta.newBuilder().setClientId("github.com/stratumn/java-chainscript").setMapId(mapId).setOutDegree(-1).setProcess(processObj).build();
        this.link = Chainscript.Link.newBuilder().setVersion("1.0.0").setMeta(linkMeta).build();
    }

    @Override
    public LinkBuilder withAction(String action) {
        this.link = this.link.toBuilder().setMeta(this.link.getMeta().toBuilder().setAction(action).build()).build();
        return this;
    }

    @Override
    public LinkBuilder withData(Object data) {
        this.linkData = data;
        return this;
    }

    @Override
    public LinkBuilder withDegree(int d) {
        this.link = this.link.toBuilder().setMeta(this.link.getMeta().toBuilder().setOutDegree(d).build()).build();
        return this;
    }

    @Override
    public LinkBuilder withMetadata(Object data) {
        this.linkMetadata = data;
        return this;
    }

    @Override
    public LinkBuilder withParent(byte[] linkHash) throws ChainscriptException {
        if (linkHash == null || linkHash.length == 0) {
            throw new ChainscriptException(Error.LinkHashMissing);
        }
        this.link = this.link.toBuilder().setMeta(this.link.getMeta().toBuilder().setPrevLinkHash(ByteString.copyFrom((byte[])linkHash)).build()).build();
        return this;
    }

    @Override
    public LinkBuilder withPriority(double priority) throws ChainscriptException {
        if (priority < 0.0) {
            throw new ChainscriptException(Error.LinkPriorityNotPositive);
        }
        this.link = this.link.toBuilder().setMeta(this.link.getMeta().toBuilder().setPriority(priority).build()).build();
        return this;
    }

    @Override
    public LinkBuilder withProcessState(String state) {
        this.link = this.link.toBuilder().setMeta(this.link.getMeta().toBuilder().setProcess(this.link.getMeta().getProcess().toBuilder().setState(state).build()).build()).build();
        return this;
    }

    @Override
    public LinkBuilder withRefs(LinkReference[] refs) throws ChainscriptException {
        if (refs != null) {
            Chainscript.LinkMeta.Builder metaBuilder = this.link.getMeta().toBuilder();
            for (int i = 0; i < refs.length; ++i) {
                LinkReference ref = refs[i];
                if (StringUtils.isEmpty((CharSequence)ref.getProcess())) {
                    throw new ChainscriptException(Error.LinkProcessMissing);
                }
                if (ref.getLinkHash() == null || ref.getLinkHash().length == 0) {
                    throw new ChainscriptException(Error.LinkHashMissing);
                }
                Chainscript.LinkReference reference = Chainscript.LinkReference.newBuilder().setLinkHash(ByteString.copyFrom((byte[])ref.getLinkHash())).setProcess(ref.getProcess()).build();
                metaBuilder.addRefs(reference);
            }
            this.link = this.link.toBuilder().setMeta(metaBuilder.build()).build();
        }
        return this;
    }

    @Override
    public LinkBuilder withStep(String step) {
        this.link = this.link.toBuilder().setMeta(this.link.getMeta().toBuilder().setStep(step).build()).build();
        return this;
    }

    @Override
    public LinkBuilder withTags(String[] tags) {
        List<String> listOfTags = Arrays.asList(tags);
        List<String> filterTags = listOfTags.stream().filter(tag -> StringUtils.isNotEmpty((CharSequence)tag)).collect(Collectors.toList());
        this.link = this.link.toBuilder().setMeta(this.link.getMeta().toBuilder().addAllTags(filterTags).build()).build();
        return this;
    }

    @Override
    public Link build() throws ChainscriptException {
        Link link = new Link(this.link);
        if (this.linkData != null) {
            link.setData(this.linkData);
        }
        if (this.linkMetadata != null) {
            link.setMetadata(this.linkMetadata);
        }
        return link;
    }
}

