/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import android.os.Message;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpRequest;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;

public abstract class SyncHttpClient
extends AsyncHttpClient {
    private int responseCode;
    private String result;
    AsyncHttpResponseHandler responseHandler = new AsyncHttpResponseHandler(){

        @Override
        void sendResponseMessage(HttpResponse response) {
            SyncHttpClient.this.responseCode = response.getStatusLine().getStatusCode();
            super.sendResponseMessage(response);
        }

        @Override
        protected void sendMessage(Message msg) {
            this.handleMessage(msg);
        }

        @Override
        public void onSuccess(String content) {
            SyncHttpClient.this.result = content;
        }

        @Override
        public void onFailure(Throwable error, String content) {
            SyncHttpClient.this.result = SyncHttpClient.this.onRequestFailed(error, content);
        }
    };

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    protected void sendRequest(DefaultHttpClient client, HttpContext httpContext, HttpUriRequest uriRequest, String contentType, AsyncHttpResponseHandler responseHandler, Context context) {
        if (contentType != null) {
            uriRequest.addHeader("Content-Type", contentType);
        }
        new AsyncHttpRequest((AbstractHttpClient)client, httpContext, uriRequest, responseHandler).run();
    }

    public abstract String onRequestFailed(Throwable var1, String var2);

    public void delete(String url, RequestParams queryParams, AsyncHttpResponseHandler responseHandler) {
        this.delete(url, responseHandler);
    }

    public String get(String url, RequestParams params) {
        this.get(url, params, this.responseHandler);
        return this.result;
    }

    public String get(String url) {
        this.get(url, null, this.responseHandler);
        return this.result;
    }

    public String put(String url, RequestParams params) {
        this.put(url, params, this.responseHandler);
        return this.result;
    }

    public String put(String url) {
        this.put(url, null, this.responseHandler);
        return this.result;
    }

    public String post(String url, RequestParams params) {
        this.post(url, params, this.responseHandler);
        return this.result;
    }

    public String post(String url) {
        this.post(url, null, this.responseHandler);
        return this.result;
    }

    public String delete(String url, RequestParams params) {
        this.delete(url, params, this.responseHandler);
        return this.result;
    }

    public String delete(String url) {
        this.delete(url, null, this.responseHandler);
        return this.result;
    }
}

