/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting;

import com.strongloop.android.remoting.VirtualObject;
import com.strongloop.android.remoting.adapters.Adapter;
import java.util.Map;

public class Repository {
    private String className;
    private Adapter adapter;

    public Repository(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("Class name cannot be null or empty.");
        }
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public VirtualObject createObject(Map<String, ? extends Object> creationParameters) {
        return new VirtualObject(this, creationParameters);
    }

    public void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        if (this.adapter == null) {
            throw new IllegalArgumentException("No adapter set");
        }
        String path = this.className + "." + method;
        this.adapter.invokeStaticMethod(path, parameters, callback);
    }
}

