/*
 * Decompiled with CFR 0.152.
 */
package com.strongloop.android.remoting.adapters;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.strongloop.android.remoting.JsonUtil;
import com.strongloop.android.remoting.adapters.Adapter;
import com.strongloop.android.remoting.adapters.RestContract;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;

public class RestAdapter
extends Adapter {
    private HttpClient client;
    private RestContract contract = new RestContract();
    private static final boolean LOG = false;

    public RestAdapter(Context context, String url) {
        super(context, url);
    }

    public RestContract getContract() {
        return this.contract;
    }

    public void setContract(RestContract contract) {
        this.contract = contract;
    }

    @Override
    public void connect(Context context, String url) {
        if (url == null) {
            this.client = null;
        } else {
            this.client = new HttpClient(context, url);
            this.client.addHeader("Accept", "application/json");
        }
    }

    @Override
    public boolean isConnected() {
        return this.client != null;
    }

    @Override
    public void invokeStaticMethod(String method, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        if (this.contract == null) {
            throw new IllegalStateException("Invalid contract");
        }
        String verb = this.contract.getVerbForMethod(method);
        String path = this.contract.getUrlForMethod(method, parameters);
        this.request(path, verb, parameters, callback);
    }

    @Override
    public void invokeInstanceMethod(String method, Map<String, ? extends Object> constructorParameters, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        if (this.contract == null) {
            throw new IllegalStateException("Invalid contract");
        }
        HashMap<String, Object> combinedParameters = new HashMap<String, Object>();
        if (constructorParameters != null) {
            combinedParameters.putAll(constructorParameters);
        }
        if (parameters != null) {
            combinedParameters.putAll(parameters);
        }
        String verb = this.contract.getVerbForMethod(method);
        String path = this.contract.getUrlForMethod(method, combinedParameters);
        this.request(path, verb, combinedParameters, callback);
    }

    private void request(String path, String verb, Map<String, ? extends Object> parameters, Adapter.Callback callback) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Adapter not connected");
        }
        this.client.request(verb, path, parameters, HttpClient.ParameterEncoding.JSON, callback);
    }

    private static class HttpClient
    extends AsyncHttpClient {
        private Context context;
        private String baseUrl;

        private static String getVersionName(Context context) {
            String appVersion = null;
            try {
                PackageInfo pinfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                appVersion = pinfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return appVersion != null ? appVersion : "";
        }

        private static String getDeviceName() {
            String deviceName = Build.MODEL;
            if (!(deviceName != null && deviceName.length() != 0 || (deviceName = Build.DEVICE) != null && deviceName.length() != 0)) {
                deviceName = "Unknown";
            }
            return deviceName;
        }

        public HttpClient(Context context, String baseUrl) {
            String appName;
            if (baseUrl == null) {
                throw new IllegalArgumentException("The baseUrl cannot be null");
            }
            this.context = context;
            this.baseUrl = baseUrl;
            if (!this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl + "/";
            }
            if (context != null) {
                String appPackageName = context.getPackageName();
                String appVersion = HttpClient.getVersionName(context);
                appName = appPackageName + "/" + appVersion;
            } else {
                appName = "StongLoopRemoting App";
            }
            String deviceName = HttpClient.getDeviceName();
            String androidVersion = Build.VERSION.RELEASE + "/API-" + Build.VERSION.SDK_INT;
            String userAgent = appName + " (" + deviceName + " Android " + androidVersion + ")";
            this.setUserAgent(userAgent);
        }

        public void request(String method, String path, Map<String, ? extends Object> parameters, ParameterEncoding parameterEncoding, final Adapter.Callback callback) {
            Uri.Builder uri = Uri.parse((String)this.baseUrl).buildUpon();
            if (path != null) {
                if (path.startsWith("/")) {
                    uri.appendEncodedPath(path.substring(1));
                } else {
                    uri.appendEncodedPath(path);
                }
            }
            String contentType = null;
            UrlEncodedFormEntity body = null;
            String charset = "utf-8";
            AsyncHttpResponseHandler httpCallback = new AsyncHttpResponseHandler(){

                public void onSuccess(String response) {
                    try {
                        callback.onSuccess(response);
                    }
                    catch (Throwable t) {
                        callback.onError(t);
                    }
                }

                public void onFailure(Throwable e, String response) {
                    callback.onError(e);
                }
            };
            if (parameters != null) {
                if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) {
                    for (Map.Entry<String, Object> entry : this.buildUrlQueryParameters(parameters).entrySet()) {
                        uri.appendQueryParameter(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                } else if (parameterEncoding == ParameterEncoding.FORM_URL) {
                    contentType = "application/x-www-form-urlencoded; charset=" + charset;
                    ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                        nameValuePairs.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
                    }
                    try {
                        body = new UrlEncodedFormEntity(nameValuePairs, charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.e((String)"RestAdapter", (String)"Couldn't encode url params", (Throwable)e);
                    }
                } else if (parameterEncoding == ParameterEncoding.JSON) {
                    contentType = "application/json; charset=" + charset;
                    String s = "";
                    try {
                        s = String.valueOf(JsonUtil.toJson(parameters));
                    }
                    catch (JSONException e) {
                        Log.e((String)"RestAdapter", (String)"Couldn't convert parameters to JSON", (Throwable)e);
                    }
                    try {
                        body = new StringEntity(s, charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.e((String)"RestAdapter", (String)"Couldn't encode JSON params", (Throwable)e);
                    }
                }
            }
            Header[] headers = new Header[]{new BasicHeader("Accept", "application/json")};
            String url = uri.build().toString();
            if ("GET".equalsIgnoreCase(method)) {
                this.get(this.context, url, headers, null, httpCallback);
            } else if ("DELETE".equalsIgnoreCase(method)) {
                this.delete(this.context, url, headers, httpCallback);
            } else if ("POST".equalsIgnoreCase(method)) {
                this.post(this.context, url, headers, (HttpEntity)body, contentType, httpCallback);
            } else if ("PUT".equalsIgnoreCase(method)) {
                this.put(this.context, url, headers, (HttpEntity)body, contentType, httpCallback);
            } else {
                throw new IllegalArgumentException("Illegal method: " + method + ". Only GET, POST, PUT, DELETE supported.");
            }
        }

        private Map<String, Object> buildUrlQueryParameters(Map<String, ? extends Object> parameters) {
            return this.buildUrlQueryParameters(null, parameters);
        }

        private Map<String, Object> buildUrlQueryParameters(String keyPrefix, Map<String, ? extends Object> parameters) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String key = keyPrefix != null ? keyPrefix + "[" + entry.getKey() + "]" : entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    result.putAll(this.buildUrlQueryParameters(key, (Map)value));
                    continue;
                }
                result.put(key, value);
            }
            return result;
        }

        static enum ParameterEncoding {
            FORM_URL,
            JSON;

        }
    }
}

