/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client;

import com.sumologic.client.Credentials;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;

public class ConnectionConfig {
    private final String protocol;
    private final String hostname;
    private final int port;
    private final Credentials credentials;
    private HttpHost proxy;

    public ConnectionConfig(String protocol, String hostname, int port, Credentials credentials) {
        this(protocol, hostname, port, credentials, null, null, 0);
    }

    public ConnectionConfig(String protocol, String hostname, int port, Credentials credentials, String proxyProtocol, String proxyHost, int proxyPort) {
        this.protocol = protocol;
        this.hostname = hostname;
        this.port = port;
        this.credentials = credentials;
        if (proxyHost != null) {
            this.proxy = new HttpHost(proxyHost, proxyPort, proxyProtocol);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public AuthScope getAuthScope() {
        return new AuthScope(this.hostname, this.port);
    }

    public UsernamePasswordCredentials getUsernamePasswordCredentials() {
        return new UsernamePasswordCredentials(this.getCredentials().getAccessId(), this.getCredentials().getAccessKey());
    }
}

