/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.collectors;

import com.sumologic.client.ConnectionConfig;
import com.sumologic.client.collectors.model.CreateCollectorRequest;
import com.sumologic.client.collectors.model.CreateCollectorResponse;
import com.sumologic.client.collectors.model.CreateSourceRequest;
import com.sumologic.client.collectors.model.CreateSourceResponse;
import com.sumologic.client.collectors.model.DeleteCollectorRequest;
import com.sumologic.client.collectors.model.DeleteCollectorResponse;
import com.sumologic.client.collectors.model.DeleteSourceRequest;
import com.sumologic.client.collectors.model.DeleteSourceResponse;
import com.sumologic.client.collectors.model.GetCollectorRequest;
import com.sumologic.client.collectors.model.GetCollectorResponse;
import com.sumologic.client.collectors.model.GetCollectorsRequest;
import com.sumologic.client.collectors.model.GetCollectorsResponse;
import com.sumologic.client.collectors.model.GetSourceRequest;
import com.sumologic.client.collectors.model.GetSourceResponse;
import com.sumologic.client.collectors.model.GetSourcesRequest;
import com.sumologic.client.collectors.model.GetSourcesResponse;
import com.sumologic.client.collectors.model.UpdateCollectorRequest;
import com.sumologic.client.collectors.model.UpdateCollectorResponse;
import com.sumologic.client.collectors.model.UpdateSourceRequest;
import com.sumologic.client.collectors.model.UpdateSourceResponse;
import com.sumologic.client.util.DeserializingResponseHandler;
import com.sumologic.client.util.HttpUtils;
import com.sumologic.client.util.PassingResponseHandler;
import com.sumologic.client.util.SumoEntityResponseHandler;

public class CollectorsClient {
    private final HttpUtils httpUtils;

    public CollectorsClient(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    public GetCollectorsResponse get(ConnectionConfig config, GetCollectorsRequest request) {
        return this.httpUtils.get(config, "collectors", request, HttpUtils.toRequestHeaders(new String[0]), new DeserializingResponseHandler(GetCollectorsResponse.class), 200);
    }

    public GetCollectorResponse get(ConnectionConfig config, GetCollectorRequest request) {
        return this.httpUtils.get(config, this.getCollectorEndpoint(request.getId()), request, HttpUtils.toRequestHeaders(new String[0]), new SumoEntityResponseHandler(GetCollectorResponse.class), 200);
    }

    public CreateCollectorResponse create(ConnectionConfig config, CreateCollectorRequest request) {
        return this.httpUtils.post(config, "collectors", request, HttpUtils.toRequestHeaders(new String[0]), new SumoEntityResponseHandler(CreateCollectorResponse.class), 201);
    }

    public UpdateCollectorResponse update(ConnectionConfig config, UpdateCollectorRequest request) {
        return this.httpUtils.put(config, this.getCollectorEndpoint(request.getId()), request, new SumoEntityResponseHandler(UpdateCollectorResponse.class), 200);
    }

    public DeleteCollectorResponse delete(ConnectionConfig config, DeleteCollectorRequest request) {
        return this.httpUtils.delete(config, this.getCollectorEndpoint(request.getId()), request, new PassingResponseHandler(new DeleteCollectorResponse()), 200);
    }

    public GetSourcesResponse getSources(ConnectionConfig config, GetSourcesRequest request) {
        return this.httpUtils.get(config, this.getSourcesEndpoint(request.getCollectorId()), request, HttpUtils.toRequestHeaders(new String[0]), new DeserializingResponseHandler(GetSourcesResponse.class), 200);
    }

    public GetSourceResponse getSource(ConnectionConfig config, GetSourceRequest request) {
        String sourceEndpoint = this.getSourceEndpoint(request.getCollectorId(), request.getSourceId());
        return this.httpUtils.get(config, sourceEndpoint, request, HttpUtils.toRequestHeaders(new String[0]), new SumoEntityResponseHandler(GetSourceResponse.class), 200);
    }

    public CreateSourceResponse createSource(ConnectionConfig config, CreateSourceRequest request) {
        return this.httpUtils.post(config, this.getSourcesEndpoint(request.getCollectorId()), request, HttpUtils.toRequestHeaders(new String[0]), new SumoEntityResponseHandler(CreateSourceResponse.class), 201);
    }

    public UpdateSourceResponse updateSource(ConnectionConfig config, UpdateSourceRequest request) {
        String sourceEndpoint = this.getSourceEndpoint(request.getCollectorId(), request.getSourceId());
        return this.httpUtils.put(config, sourceEndpoint, request, new SumoEntityResponseHandler(UpdateSourceResponse.class), 200);
    }

    public DeleteSourceResponse deleteSource(ConnectionConfig config, DeleteSourceRequest request) {
        String sourceEndpoint = this.getSourceEndpoint(request.getCollectorId(), request.getSourceId());
        return this.httpUtils.delete(config, sourceEndpoint, request, new PassingResponseHandler(new DeleteSourceResponse()), 200);
    }

    private String getCollectorEndpoint(Long collectorId) {
        return "collectors/" + collectorId;
    }

    private String getSourcesEndpoint(Long collectorId) {
        return this.getCollectorEndpoint(collectorId) + "/" + "sources";
    }

    private String getSourceEndpoint(Long collectorId, Long sourceId) {
        return this.getSourcesEndpoint(collectorId) + "/" + sourceId;
    }
}

