/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.collectors;

import com.sumologic.client.Credentials;
import com.sumologic.client.SumoLogicClient;
import com.sumologic.client.collectors.model.Collector;
import com.sumologic.client.collectors.model.GetCollectorsResponse;
import com.sumologic.client.collectors.model.GetSourcesRequest;
import com.sumologic.client.collectors.model.GetSourcesResponse;
import com.sumologic.client.collectors.model.Source;
import java.util.List;

public class CollectorAndBladeIdDumper {
    public static void main(String[] args) throws Exception {
        String url = args[0];
        String accessId = args[1];
        String accessKey = args[2];
        Credentials credential = new Credentials(accessId, accessKey);
        SumoLogicClient sumoClient = new SumoLogicClient(credential);
        sumoClient.setURL(url);
        GetCollectorsResponse getCollectorResponse = sumoClient.getCollectors();
        List<Collector> collectors = getCollectorResponse.getCollectors();
        for (Collector collector : collectors) {
            System.err.printf("Collector ID: '%016X', name: '%s'\n", collector.getId(), collector.getName());
            long offset = 0L;
            long increment = 50L;
            boolean done = false;
            while (!done) {
                GetSourcesRequest getSourcesRequest = new GetSourcesRequest(collector.getId());
                getSourcesRequest.setOffset(offset);
                getSourcesRequest.setLimit(increment);
                GetSourcesResponse getSourcesResponse = sumoClient.getSources(getSourcesRequest);
                List<Source> sources = getSourcesResponse.getSources();
                for (Source source : sources) {
                    System.err.printf("   Source ID: '%016X', name: '%s'\n", source.getId(), source.getName());
                }
                offset += increment;
                if ((long)sources.size() >= increment) continue;
                done = true;
            }
        }
    }
}

