/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.sumologic.client.ConnectionConfig;
import com.sumologic.client.SumoClientException;
import com.sumologic.client.SumoServerException;
import com.sumologic.client.model.HttpDeleteRequest;
import com.sumologic.client.model.HttpGetRequest;
import com.sumologic.client.model.HttpPostRequest;
import com.sumologic.client.model.HttpPutRequest;
import com.sumologic.client.util.JacksonUtils;
import com.sumologic.client.util.ResponseHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpUtils {
    public static final int API_VERSION = 1;
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final CookieStore cookieStore = new BasicCookieStore();

    public <Request extends HttpGetRequest, Response> Response get(ConnectionConfig config, String endpoint, Request request, Map<String, String> requestHeaders, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        return this.get(config, endpoint, request, 60000, requestHeaders, handler, expectedStatusCode);
    }

    public <Request extends HttpGetRequest, Response> Response get(ConnectionConfig config, String endpoint, Request request, int timeout, Map<String, String> requestHeaders, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            String params = URLEncodedUtils.format(request.toUrlParams(), (String)"UTF-8");
            URI uri = URIUtils.createURI((String)config.getProtocol(), (String)config.getHostname(), (int)config.getPort(), (String)HttpUtils.getEndpointURI(endpoint), (String)params, null);
            HttpGet get = new HttpGet(uri);
            return this.doRequest(config, timeout, (HttpUriRequest)get, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException e) {
            throw new SumoClientException("URI cannot be generated", e);
        }
    }

    public <Request extends HttpPostRequest, Response> Response post(ConnectionConfig config, String endpoint, Request request, Map<String, String> requestHeaders, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            URI uri = URIUtils.createURI((String)config.getProtocol(), (String)config.getHostname(), (int)config.getPort(), (String)HttpUtils.getEndpointURI(endpoint), null, null);
            HttpPost post = new HttpPost(uri);
            String body = JacksonUtils.MAPPER.writeValueAsString(request);
            StringEntity entity = new StringEntity(body, "UTF-8");
            entity.setContentType(JSON_CONTENT_TYPE);
            post.setEntity((HttpEntity)entity);
            return this.doRequest(config, (HttpUriRequest)post, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException e) {
            throw new SumoClientException("URI cannot be generated", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SumoClientException("Unsupported character encoding", e);
        }
        catch (JsonMappingException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
        catch (JsonGenerationException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
        catch (IOException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
    }

    public <Request extends HttpPutRequest, Response> Response put(ConnectionConfig config, String endpoint, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            URI uri = URIUtils.createURI((String)config.getProtocol(), (String)config.getHostname(), (int)config.getPort(), (String)HttpUtils.getEndpointURI(endpoint), null, null);
            HttpPut put = new HttpPut(uri);
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (request.getETag() != null) {
                requestHeaders.put("If-Match", request.getETag());
            }
            String body = JacksonUtils.MAPPER.writeValueAsString(request);
            StringEntity entity = new StringEntity(body, "UTF-8");
            entity.setContentType(JSON_CONTENT_TYPE);
            put.setEntity((HttpEntity)entity);
            return this.doRequest(config, (HttpUriRequest)put, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException ex) {
            throw new SumoClientException("URI cannot be generated", ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SumoClientException("Unsupported character encoding", ex);
        }
        catch (JsonMappingException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
        catch (JsonGenerationException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
        catch (IOException e) {
            throw new SumoClientException("Error generating JSON", e);
        }
    }

    public <Request extends HttpDeleteRequest, Response> Response delete(ConnectionConfig config, String endpoint, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        try {
            URI uri = URIUtils.createURI((String)config.getProtocol(), (String)config.getHostname(), (int)config.getPort(), (String)HttpUtils.getEndpointURI(endpoint), null, null);
            HttpDelete delete = new HttpDelete(uri);
            Map<String, String> requestHeaders = HttpUtils.toRequestHeaders(new String[0]);
            return this.doRequest(config, (HttpUriRequest)delete, requestHeaders, request, handler, expectedStatusCode);
        }
        catch (URISyntaxException ex) {
            throw new SumoClientException("URI cannot be generated", ex);
        }
    }

    public static Map<String, String> toRequestHeaders(String ... parts) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < parts.length; ++i) {
            result.put(parts[i], parts[++i]);
        }
        return result;
    }

    private HttpClient getHttpClient(ConnectionConfig config) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.setCookieStore(this.cookieStore);
        httpClient.getCredentialsProvider().setCredentials(config.getAuthScope(), (Credentials)config.getUsernamePasswordCredentials());
        return httpClient;
    }

    private static String getEndpointURI(String endpoint) {
        return "/api/v1/" + endpoint;
    }

    private <Request, Response> Response doRequest(ConnectionConfig config, HttpUriRequest method, Map<String, String> requestHeaders, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        return this.doRequest(config, 60000, method, requestHeaders, request, handler, expectedStatusCode);
    }

    private <Request, Response> Response doRequest(ConnectionConfig config, int timeout, HttpUriRequest method, Map<String, String> requestHeaders, Request request, ResponseHandler<Request, Response> handler, int expectedStatusCode) {
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            method.setHeader(header.getKey(), header.getValue());
        }
        HttpClient httpClient = this.getHttpClient(config);
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        InputStream httpStream = null;
        try {
            HttpResponse httpResponse = httpClient.execute(method);
            HttpEntity entity = httpResponse.getEntity();
            httpStream = entity.getContent();
            if (httpResponse.getStatusLine().getStatusCode() == expectedStatusCode) {
                Response Response = handler.handle(httpResponse, httpStream, request);
                return Response;
            }
            try {
                String s;
                StringWriter writer = new StringWriter();
                BufferedReader reader = new BufferedReader(new InputStreamReader(httpStream));
                while ((s = reader.readLine()) != null) {
                    writer.write(s + "\n");
                }
                String json = writer.toString();
                if (JacksonUtils.isValidJson(json)) {
                    throw new SumoServerException(method.getURI().toString(), writer.toString());
                }
                throw new SumoServerException(method.getURI().toString(), httpResponse.getStatusLine().getStatusCode());
            }
            catch (IOException ex) {
                throw new SumoClientException("Error reading server response", ex);
            }
            catch (RuntimeException ex) {
                if (ex instanceof SumoServerException) {
                    throw ex;
                }
                throw new SumoClientException("Runtime error reading server response", ex);
            }
        }
        finally {
            if (httpStream != null) {
                try {
                    httpStream.close();
                }
                catch (IOException ex) {}
            }
            httpClient.getConnectionManager().shutdown();
            if (method != null) {
                method.abort();
            }
        }
    }
}

