/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.collectors.model;

import com.sumologic.client.collectors.model.AlertSource;
import com.sumologic.client.collectors.model.AmazonS3Source;
import com.sumologic.client.collectors.model.HttpSource;
import com.sumologic.client.collectors.model.LocalFileSource;
import com.sumologic.client.collectors.model.RemoteFileSource;
import com.sumologic.client.collectors.model.RemoteWindowsEventLogSource;
import com.sumologic.client.collectors.model.ScriptSource;
import com.sumologic.client.collectors.model.Source;
import com.sumologic.client.collectors.model.SyslogSource;
import com.sumologic.client.collectors.model.WindowsEventLogSource;
import java.util.HashMap;
import java.util.Map;

public enum SourceType {
    LOCAL_FILE("LocalFile", LocalFileSource.class),
    REMOTE_FILE("RemoteFile", RemoteFileSource.class),
    SYSLOG("Syslog", SyslogSource.class),
    LOCAL_WINDOWS_EVENT_LOG("LocalWindowsEventLog", WindowsEventLogSource.class),
    REMOTE_WINDOWS_EVENT_LOG("RemoteWindowsEventLog", RemoteWindowsEventLogSource.class),
    SCRIPT("Script", ScriptSource.class),
    ALERT("Alert", AlertSource.class),
    AMAZON_S3("AmazonS3", AmazonS3Source.class),
    HTTP("HTTP", HttpSource.class);

    private String type;
    private Class<? extends Source> sourceClass;
    private static Map<String, Class<? extends Source>> SOURCE_TYPE_MAP;

    private SourceType(String type, Class<? extends Source> sourceClass) {
        this.type = type;
        this.sourceClass = sourceClass;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends Source> getSourceClass() {
        return this.sourceClass;
    }

    public static Class<? extends Source> getSourceClass(String type) {
        return SOURCE_TYPE_MAP.get(type);
    }

    static {
        SOURCE_TYPE_MAP = new HashMap<String, Class<? extends Source>>();
        for (SourceType sourceType : SourceType.values()) {
            SOURCE_TYPE_MAP.put(sourceType.getType(), sourceType.getSourceClass());
        }
    }
}

