/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sumologic.client.SumoClientException;
import com.sumologic.client.SumoException;
import com.sumologic.client.SumoServerError;
import com.sumologic.client.util.JacksonUtils;
import java.util.Map;

public class SumoServerException
extends SumoException {
    private String uri;
    private int status;
    private String message;
    private String id;
    private String code;

    public SumoServerException(String uri, int status) {
        super("The server responded with HTTP Status: " + status);
        this.uri = uri;
        this.status = status;
        this.message = null;
        this.id = null;
        this.code = null;
    }

    public SumoServerException(String uri, String json) throws SumoClientException {
        super(json);
        this.uri = uri;
        try {
            Map kv = (Map)JacksonUtils.MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
            this.status = Integer.parseInt((String)kv.get("status"));
            this.message = (String)kv.get("message");
            this.id = (String)kv.get("id");
            this.code = (String)kv.get("code");
        }
        catch (Exception e) {
            throw new SumoClientException("Exception while parsing JSON: \n" + json, e);
        }
    }

    public final int getHTTPStatus() {
        return this.status;
    }

    public final String getErrorId() {
        return this.id;
    }

    public final String getErrorCode() {
        return this.code;
    }

    public final String getErrorMessage() {
        return this.message;
    }

    public final String getURI() {
        return this.uri;
    }

    public boolean equals(SumoServerError error) {
        return this.id != null && error.getId().equals(this.id.toLowerCase().trim());
    }
}

