/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.client.searchjob;

import au.com.bytecode.opencsv.CSVWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sumologic.client.Credentials;
import com.sumologic.client.SumoLogicClient;
import com.sumologic.client.model.LogMessage;
import com.sumologic.client.searchjob.model.GetMessagesForSearchJobResponse;
import com.sumologic.client.searchjob.model.GetRecordsForSearchJobResponse;
import com.sumologic.client.searchjob.model.GetSearchJobStatusResponse;
import com.sumologic.client.searchjob.model.SearchJobRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SearchJobResultDumper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        url = null;
        accessId = null;
        accessKey = null;
        startTimestamp = null;
        endTimestamp = null;
        timezone = null;
        byReceiptTime = null;
        chunkIncrementMillis = -1L;
        searchQuery = null;
        searchQueryFilename = null;
        outputFormat = OutputFormat.CSV;
        dumpAggregates = false;
        lastEndFile = null;
        retry = 1;
        options = SearchJobResultDumper.createOptions();
        try {
            parser = new GnuParser();
            commandLine = parser.parse(options, args);
            url = commandLine.getOptionValue("url");
            accessId = commandLine.getOptionValue("accessid");
            accessKey = commandLine.getOptionValue("accesskey");
            if (commandLine.hasOption("catchup")) {
                thisHour = (long)Math.floor((double)(System.currentTimeMillis() / 60L / 60L) / 1000.0) * 3600000L;
                endTimestamp = Long.toString(thisHour);
                timezone = "UTC";
                if (commandLine.hasOption("catchup-file")) {
                    catchupFile = commandLine.getOptionValue("catchup-file");
                    try {
                        startTimestamp = SearchJobResultDumper.readTimestampFromFile(catchupFile);
                    }
                    catch (IOException ioe) {
                        if (!commandLine.hasOption("ignore-missing-catchup-file")) {
                            throw new ParseException(String.format("Error reading catchup file: '%s' ('%s')", new Object[]{catchupFile, ioe.getMessage()}));
                        }
                        System.err.printf("Ignoring missing catchup file: '%s' ('%s')\n", new Object[]{catchupFile, ioe.getMessage()});
                    }
                }
                if (startTimestamp == null) {
                    catchupHours = Long.parseLong(commandLine.getOptionValue("catchup"));
                    startTimestamp = Long.toString(thisHour - catchupHours * 60L * 60L * 1000L);
                }
            } else {
                if (!commandLine.hasOption("from")) {
                    throw new ParseException("-f/--from required if -c/--catchup is omitted");
                }
                startTimestamp = commandLine.getOptionValue("from");
                if (!commandLine.hasOption("to")) {
                    throw new ParseException("-t/--to required if -c/--catchup is omitted");
                }
                endTimestamp = commandLine.getOptionValue("to");
                if (!commandLine.hasOption("tz")) {
                    throw new ParseException("-tz/--timezone required if -c/--catchup is omitted");
                }
                timezone = commandLine.getOptionValue("timezone");
            }
            if (commandLine.hasOption("hours") && commandLine.hasOption("minutes")) {
                throw new ParseException("Please specify only one of --hours and --minutes");
            }
            if (commandLine.hasOption("hours")) {
                chunkIncrementMillis = 3600000L * Long.parseLong(commandLine.getOptionValue("hours"));
            }
            if (commandLine.hasOption("minutes")) {
                chunkIncrementMillis = 60000L * Long.parseLong(commandLine.getOptionValue("minutes"));
            }
            if (commandLine.hasOption("byReceiptTime")) {
                byReceiptTime = commandLine.getOptionValue("byReceiptTime");
            }
            searchQuery = commandLine.getOptionValue("query");
            searchQueryFilename = commandLine.getOptionValue("file");
            if (commandLine.hasOption("json")) {
                outputFormat = OutputFormat.JSON;
            }
            if (commandLine.hasOption("aggregates")) {
                dumpAggregates = true;
            }
            if (searchQuery == null && searchQueryFilename == null) {
                throw new ParseException("Either -q/--query or --file needs to be specified");
            }
            if (commandLine.hasOption("last-end-file")) {
                lastEndFile = commandLine.getOptionValue("last-end-file");
            }
            if (commandLine.hasOption("retry")) {
                retryValue = commandLine.getOptionValue("retry");
                retry = Integer.parseInt(retryValue);
            }
        }
        catch (ParseException exp) {
            System.err.println(exp.getMessage());
            formatter = new HelpFormatter();
            formatter.printHelp("SearchJobResultsDumper", options);
            System.exit(1);
        }
        credential = new Credentials(accessId, accessKey);
        sumoClient = new SumoLogicClient(credential);
        sumoClient.setURL(url);
        if (searchQuery == null && searchQueryFilename != null) {
            searchQuery = SearchJobResultDumper.readQueryStringFromFile(searchQueryFilename);
        }
        startMillis = SearchJobResultDumper.getMillis(startTimestamp, timezone);
        endMillis = SearchJobResultDumper.getMillis(endTimestamp, timezone);
        chunkIncrementMillisToUse = endMillis - startMillis;
        if (chunkIncrementMillis != -1L) {
            chunkIncrementMillisToUse = chunkIncrementMillis;
        }
        csvWriter = null;
        headerWritten = new AtomicBoolean(false);
        csvWriter = new CSVWriter((Writer)new OutputStreamWriter(System.out));
        objectMapper = new ObjectMapper();
        overallStartTimestamp = System.currentTimeMillis();
        failure = false;
        try {
            do {
                chunkStartMillis = startMillis;
                chunkEndMillis = startMillis + chunkIncrementMillisToUse;
                chunkEndMillis = Math.min(chunkEndMillis, endMillis);
                executionStartMillis = System.currentTimeMillis();
                prefix = String.format("Chunk from: '%s' to: '%s'", new Object[]{new Date(chunkStartMillis), new Date(chunkEndMillis)});
                System.err.printf("--> %s\n", new Object[]{prefix});
                failure = SearchJobResultDumper.executeSearchJobWithRetry(csvWriter, headerWritten, objectMapper, outputFormat, prefix, sumoClient, searchQuery, dumpAggregates, "" + chunkStartMillis, "" + chunkEndMillis, timezone, retry, lastEndFile, byReceiptTime);
                if (failure) ** break;
                elapsed = System.currentTimeMillis() - executionStartMillis;
                System.err.printf("-----> Done in millis: '%d'\n", new Object[]{elapsed});
            } while ((startMillis += chunkIncrementMillisToUse) < endMillis);
        }
        catch (Throwable var40_37) {
            try {
                csvWriter.close();
            }
            catch (IOException ioe) {
                System.err.printf("Error closing CSV writer: '%s'", new Object[]{ioe.getMessage()});
                ioe.printStackTrace(System.err);
            }
            throw var40_37;
        }
        try {
            csvWriter.close();
        }
        catch (IOException ioe) {
            System.err.printf("Error closing CSV writer: '%s'", new Object[]{ioe.getMessage()});
            ioe.printStackTrace(System.err);
        }
        overallElapsed = System.currentTimeMillis() - overallStartTimestamp;
        System.err.printf("======> Done overall in millis: '%d'\n", new Object[]{overallElapsed});
        if (failure) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.println("Finished with errors");
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.exit(1);
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"url");
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)"URL of the Sumo Logic API endpoint");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withLongOpt((String)"accessid");
        OptionBuilder.withArgName((String)"accessid");
        OptionBuilder.withDescription((String)"Access id of the user to login as");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"accesskey");
        OptionBuilder.withArgName((String)"accesskey");
        OptionBuilder.withDescription((String)"Access key of the user to login as");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"k"));
        OptionBuilder.withLongOpt((String)"from");
        OptionBuilder.withArgName((String)"from");
        OptionBuilder.withDescription((String)"Start timestamp in ISO8601 format, or in milliseconds since the epoch");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"to");
        OptionBuilder.withArgName((String)"to");
        OptionBuilder.withDescription((String)"End timestamp in ISO8601 format, or in milliseconds since the epoch");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"timezone");
        OptionBuilder.withArgName((String)"timezone");
        OptionBuilder.withDescription((String)"The timezone to interpret from and to in");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"tz"));
        OptionBuilder.withLongOpt((String)"byReceiptTime");
        OptionBuilder.withArgName((String)"byReceiptTime");
        OptionBuilder.withDescription((String)"Search by receipt time instead of message time");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"rt"));
        OptionBuilder.withLongOpt((String)"hours");
        OptionBuilder.withArgName((String)"hours");
        OptionBuilder.withDescription((String)"The number of hours to chunk the search query");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"minutes");
        OptionBuilder.withArgName((String)"minutes");
        OptionBuilder.withDescription((String)"The number of minutes to chunk the search query");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"catchup");
        OptionBuilder.withArgName((String)"catchup");
        OptionBuilder.withDescription((String)"The number of hours to catchup");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"catchup-file");
        OptionBuilder.withArgName((String)"catchup-file");
        OptionBuilder.withDescription((String)"The file containing the timestamp from which to catch up from");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"cf"));
        OptionBuilder.withLongOpt((String)"ignore-missing-catchup-file");
        OptionBuilder.withArgName((String)"ignore-missing-catchup-file");
        OptionBuilder.withDescription((String)"If the specified catchup file is missing, ignore and use the --catchup value");
        options.addOption(OptionBuilder.create((String)"imcf"));
        OptionBuilder.withLongOpt((String)"query");
        OptionBuilder.withArgName((String)"query");
        OptionBuilder.withDescription((String)"The query to execute");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"q"));
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"The file containing the query to execute");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"csv");
        OptionBuilder.withArgName((String)"csv");
        OptionBuilder.withDescription((String)"Format the output as CSV");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"aggregates");
        OptionBuilder.withArgName((String)"aggregates");
        OptionBuilder.withDescription((String)"Output the aggregate results, not the messages");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"json");
        OptionBuilder.withArgName((String)"json");
        OptionBuilder.withDescription((String)"Format the output as JSON");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"last-end-file");
        OptionBuilder.withArgName((String)"last-end-file");
        OptionBuilder.withDescription((String)"Name of the file to write the end timestamp of the last successful run");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"le"));
        OptionBuilder.withLongOpt((String)"retry");
        OptionBuilder.withArgName((String)"retry");
        OptionBuilder.withDescription((String)"Number of times to retry a query in case of an error");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"r"));
        return options;
    }

    private static String readQueryStringFromFile(String fileName) throws IOException {
        InputStream is = null;
        is = fileName.startsWith("http") ? new URL(fileName).openStream() : new FileInputStream(fileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String line = null;
        StringBuilder sb = new StringBuilder(1024);
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    private static String readTimestampFromFile(String filename) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));){
            String string = reader.readLine();
            return string;
        }
    }

    private static boolean executeSearchJobWithRetry(CSVWriter csvWriter, AtomicBoolean headerWritten, ObjectMapper objectMapper, OutputFormat outputFormat, String prefix, SumoLogicClient sumoClient, String searchQuery, boolean dumpAggregates, String startTimestamp, String endTimestamp, String timeZone, int retry, String lastEndFile, String byReceiptTime) {
        int triesLeft = retry;
        int attempt = 1;
        boolean failure = true;
        while (triesLeft > 0 && failure) {
            --triesLeft;
            failure = SearchJobResultDumper.executeSearch(csvWriter, headerWritten, objectMapper, outputFormat, prefix, sumoClient, searchQuery, dumpAggregates, startTimestamp, endTimestamp, timeZone, attempt, lastEndFile, byReceiptTime);
            if (failure) {
                System.err.println(String.format("Got an error on attempt: '%d', tries left: '%d'", attempt, triesLeft));
            }
            ++attempt;
        }
        return failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean executeSearch(CSVWriter csvWriter, AtomicBoolean headerWritten, ObjectMapper objectMapper, OutputFormat outputFormat, String prefix, SumoLogicClient sumoClient, String searchQuery, boolean dumpAggregates, String startTimestamp, String endTimestamp, String timeZone, int attempt, String lastEndFile, String byReceiptTime) {
        searchJobId = sumoClient.createSearchJob(searchQuery, startTimestamp, endTimestamp, timeZone, byReceiptTime);
        System.err.printf("[%s] %s - Search job ID: '%s', attempt: '%d'\n", new Object[]{new Date(), prefix, searchJobId, attempt});
        try {
            messageCount = 0;
            recordCount = 0;
            offset = 0;
            getSearchJobStatusResponse = null;
lbl9:
            // 3 sources

            while (getSearchJobStatusResponse == null || !SearchJobResultDumper.isDone(getSearchJobStatusResponse) && !SearchJobResultDumper.isCancelled(getSearchJobStatusResponse)) {
                startMillis = System.currentTimeMillis();
                getSearchJobStatusResponse = sumoClient.getSearchJobStatus(searchJobId);
                if (SearchJobResultDumper.isCancelled(getSearchJobStatusResponse)) {
                    System.err.println("Ugh. Search job was cancelled. Exiting...");
                    System.err.flush();
                    System.exit(1);
                }
                if ((warnings = getSearchJobStatusResponse.getPendingWarnings()) != null && warnings.size() > 0) {
                    System.err.println("WARNINGS:");
                    for (String var23_28 : warnings) {
                        System.err.println(var23_28);
                    }
                }
                if ((errors = getSearchJobStatusResponse.getPendingErrors()) == null || errors.size() <= 0) ** GOTO lbl-1000
                System.err.println("ERROR:");
                for (String error : errors) {
                    System.err.println(error);
                }
                System.err.flush();
                var23_30 = true;
                ** GOTO lbl49
            }
            ** GOTO lbl69
        }
        catch (Throwable t) {
            try {
                System.err.printf("Uncaught exception: '%s'", new Object[]{t.getMessage()});
                t.printStackTrace(System.err);
                System.err.flush();
                var16_17 = true;
            }
            catch (Throwable var25_34) {
                try {
                    sumoClient.cancelSearchJob(searchJobId);
                    throw var25_34;
                }
                catch (Throwable t) {
                    System.err.printf("Error cancelling search job: '%s'", new Object[]{t.getMessage()});
                    t.printStackTrace(System.err);
                    System.err.flush();
                }
                throw var25_34;
            }
lbl49:
            // 1 sources

            try {
                sumoClient.cancelSearchJob(searchJobId);
                return var23_30;
            }
            catch (Throwable t) {
                System.err.printf("Error cancelling search job: '%s'", new Object[]{t.getMessage()});
                t.printStackTrace(System.err);
                System.err.flush();
            }
            return var23_30;
lbl-1000:
            // 1 sources

            {
                messageCount = getSearchJobStatusResponse.getMessageCount();
                recordCount = getSearchJobStatusResponse.getRecordCount();
                System.err.printf("[%s] %s - Search job ID: '%s',  attempt: '%d', messages: '%d', records: '%d'\n", new Object[]{new Date(), prefix, searchJobId, attempt, messageCount, recordCount});
                if (!dumpAggregates) {
                    offset = SearchJobResultDumper.getMessages(csvWriter, headerWritten, objectMapper, outputFormat, prefix, sumoClient, searchJobId, offset, messageCount);
                }
                var23_27 = System.currentTimeMillis();
                if (SearchJobResultDumper.isDone(getSearchJobStatusResponse)) ** GOTO lbl9
                SearchJobResultDumper.gracePeriod(prefix, searchJobId, startMillis, var23_27);
                ** GOTO lbl9
lbl69:
                // 1 sources

                if (dumpAggregates) {
                    SearchJobResultDumper.getRecords(csvWriter, headerWritten, objectMapper, outputFormat, prefix, sumoClient, searchJobId, 0, recordCount);
                }
                if (lastEndFile != null) {
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(lastEndFile)));
                        writer.write(endTimestamp);
                        writer.close();
                    }
                    catch (IOException ioe) {
                        System.err.printf("Uncaught exception: '%s'", new Object[]{ioe.getMessage()});
                        ioe.printStackTrace(System.err);
                        System.err.flush();
                    }
                }
                var19_24 = false;
            }
            try {
                sumoClient.cancelSearchJob(searchJobId);
                return var19_24;
            }
            catch (Throwable t) {
                System.err.printf("Error cancelling search job: '%s'", new Object[]{t.getMessage()});
                t.printStackTrace(System.err);
                System.err.flush();
            }
            return var19_24;
            try {
                sumoClient.cancelSearchJob(searchJobId);
                return var16_17;
            }
            catch (Throwable t) {
                System.err.printf("Error cancelling search job: '%s'", new Object[]{t.getMessage()});
                t.printStackTrace(System.err);
                System.err.flush();
            }
            return var16_17;
        }
    }

    private static int getMessages(CSVWriter csvWriter, AtomicBoolean headerWritten, ObjectMapper objectMapper, OutputFormat outputFormat, String prefix, SumoLogicClient sumoClient, String searchJobId, int messageOffset, int messageCount) {
        int messageLength = 0;
        while ((messageLength = messageCount - messageOffset) > 0) {
            List<LogMessage> messages;
            GetMessagesForSearchJobResponse getMessagesForSearchJobResponse;
            if (outputFormat == OutputFormat.CSV && !headerWritten.get()) {
                getMessagesForSearchJobResponse = sumoClient.getMessagesForSearchJob(searchJobId, 0, 1);
                messages = getMessagesForSearchJobResponse.getMessages();
                ArrayList<String> fieldNames = new ArrayList<String>(messages.get(0).getFieldNames());
                Collections.sort(fieldNames);
                String[] headers = new String[fieldNames.size()];
                for (int i = 0; i < fieldNames.size(); ++i) {
                    String fieldName;
                    headers[i] = fieldName = (String)fieldNames.get(i);
                }
                csvWriter.writeNext(headers);
                headerWritten.set(true);
            }
            if ((messageLength = Math.min(messageLength, 1000)) <= 0) continue;
            System.err.printf("[%s] %s - Search job ID: '%s', messages: '%s', getting offset: '%d', length: '%d'\n", new Date(), prefix, searchJobId, messageCount, messageOffset, messageLength);
            System.err.flush();
            getMessagesForSearchJobResponse = sumoClient.getMessagesForSearchJob(searchJobId, messageOffset, messageLength);
            messageOffset += messageLength;
            try {
                messages = getMessagesForSearchJobResponse.getMessages();
                for (LogMessage message : messages) {
                    Map<String, String> fields = message.getMap();
                    ArrayList<String> fieldNames = new ArrayList<String>(message.getFieldNames());
                    Collections.sort(fieldNames);
                    if (outputFormat == OutputFormat.CSV) {
                        String[] csv = new String[fields.size()];
                        for (int i = 0; i < fieldNames.size(); ++i) {
                            String fieldValue;
                            String fieldName = (String)fieldNames.get(i);
                            csv[i] = fieldValue = fields.get(fieldName);
                        }
                        csvWriter.writeNext(csv);
                    }
                    if (outputFormat != OutputFormat.JSON) continue;
                    String json = objectMapper.writeValueAsString(fields);
                    System.out.println(json);
                }
            }
            catch (IOException ioe) {
                System.err.printf("Error writing JSON: '%s'", ioe.getMessage());
                ioe.printStackTrace(System.err);
            }
        }
        return messageOffset;
    }

    private static int getRecords(CSVWriter csvWriter, AtomicBoolean headerWritten, ObjectMapper objectMapper, OutputFormat outputFormat, String prefix, SumoLogicClient sumoClient, String searchJobId, int recordOffset, int recordCount) {
        if (outputFormat == OutputFormat.CSV && !headerWritten.get()) {
            GetRecordsForSearchJobResponse getRecordsForSearchJobResponse = sumoClient.getRecordsForSearchJob(searchJobId, 0, 1);
            List<SearchJobRecord> records = getRecordsForSearchJobResponse.getRecords();
            ArrayList<String> fieldNames = new ArrayList<String>(records.get(0).getFieldNames());
            Collections.sort(fieldNames);
            String[] headers = new String[fieldNames.size()];
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldName;
                headers[i] = fieldName = (String)fieldNames.get(i);
            }
            csvWriter.writeNext(headers);
            headerWritten.set(true);
        }
        int recordLength = 0;
        while ((recordLength = recordCount - recordOffset) > 0) {
            if ((recordLength = Math.min(recordLength, 1000)) <= 0) continue;
            System.err.printf("[%s] %s - Search job ID: '%s', records: '%s', getting offset: '%d', length: '%d'\n", new Date(), prefix, searchJobId, recordCount, recordOffset, recordLength);
            System.err.flush();
            GetRecordsForSearchJobResponse getRecordsForSearchJobResponse = sumoClient.getRecordsForSearchJob(searchJobId, recordOffset, recordLength);
            recordOffset += recordLength;
            try {
                List<SearchJobRecord> records = getRecordsForSearchJobResponse.getRecords();
                for (SearchJobRecord record : records) {
                    Map<String, String> fields = record.getMap();
                    ArrayList<String> fieldNames = new ArrayList<String>(record.getFieldNames());
                    Collections.sort(fieldNames);
                    if (outputFormat == OutputFormat.CSV) {
                        String[] csv = new String[fields.size()];
                        for (int i = 0; i < fieldNames.size(); ++i) {
                            String fieldValue;
                            String fieldName = (String)fieldNames.get(i);
                            csv[i] = fieldValue = fields.get(fieldName);
                        }
                        csvWriter.writeNext(csv);
                    }
                    if (outputFormat != OutputFormat.JSON) continue;
                    String json = objectMapper.writeValueAsString(fields);
                    System.out.println(json);
                }
            }
            catch (IOException ioe) {
                System.err.printf("Error writing JSON: '%s'", ioe.getMessage());
                ioe.printStackTrace(System.err);
            }
        }
        if (outputFormat == OutputFormat.CSV) {
            try {
                csvWriter.flush();
            }
            catch (IOException ioe) {
                System.err.printf("Error flushing CSV writer: '%s'", ioe.getMessage());
                ioe.printStackTrace(System.err);
            }
        }
        return recordOffset;
    }

    private static long getMillis(String timestamp, String timezone) {
        if (SearchJobResultDumper.isLong(timestamp)) {
            return Long.parseLong(timestamp);
        }
        return SearchJobResultDumper.iso8601toMillis(timestamp, timezone);
    }

    private static boolean isLong(String s) {
        try {
            long dummy = Long.parseLong(s);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static long iso8601toMillis(String timestamp, String timezone) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_TIME).toFormatter();
        TimeZone tz = TimeZone.getTimeZone(timezone);
        int offset = tz.getRawOffset();
        if (tz.inDaylightTime(new Date())) {
            offset += tz.getDSTSavings();
        }
        int offsetHours = offset / 1000 / 60 / 60;
        int offsetMinutes = offset / 1000 / 60 % 60;
        String timestampWithTimezone = String.format("%s%+03d:%02d", timestamp, offsetHours, offsetMinutes);
        return OffsetDateTime.parse(timestampWithTimezone, formatter).toInstant().toEpochMilli();
    }

    private static boolean isCancelled(GetSearchJobStatusResponse getSearchJobStatusResponse) {
        return getSearchJobStatusResponse.getState().equals("CANCELLED");
    }

    private static boolean isDone(GetSearchJobStatusResponse getSearchJobStatusResponse) {
        return getSearchJobStatusResponse.getState().equals("DONE GATHERING RESULTS");
    }

    private static void gracePeriod(String prefix, String searchJobId, long startMillis, long endMillis) throws InterruptedException {
        long maxWaitMillis = 5000L;
        long delta = endMillis - startMillis;
        long waitMillis = Math.max(0L, Math.min(maxWaitMillis - delta, maxWaitMillis));
        System.err.printf("[%s] %s - Search job ID: '%s', sleeping for: '%d' milliseconds\n", new Date(), prefix, searchJobId, waitMillis);
        System.err.flush();
        Thread.sleep(waitMillis);
    }

    static enum OutputFormat {
        CSV,
        JSON;

    }
}

