/*
 * Decompiled with CFR 0.152.
 */
package com.supalle.tools.code;

import java.util.Collection;
import java.util.List;

public abstract class AbstractLinkedArrayList<E>
implements List<E> {
    static final int CACHE_LINE_SIZE = 64;
    static final int OBJECT_HEADER_SIZE = 16;
    static final int ELEMENT_SIZE = 12;
    static final int NEXT_ELEMENT_INDEX = 11;
    static final Object EMPTY_ELEMENT = new Object(){

        public String toString() {
            return "EMPTY_ELEMENT@" + Integer.toHexString(this.hashCode());
        }
    };
    static final Object[] ELEMENTS_TEMPLATE = new Object[12];

    protected final boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    protected final boolean isNotEmpty(Collection<?> collection) {
        return !this.isEmpty(collection);
    }

    static {
        for (int i = 0; i < 12; ++i) {
            AbstractLinkedArrayList.ELEMENTS_TEMPLATE[i] = EMPTY_ELEMENT;
        }
    }

    static class ElementIndex {
        private final int index;
        private final Object[] elements;
        private final Object[] preElements;
        private final Object[] nextElements;

        public ElementIndex(int index, Object[] elements, Object[] preElements, Object[] nextElements) {
            this.index = index;
            this.elements = elements;
            this.preElements = preElements;
            this.nextElements = nextElements;
        }

        public int getIndex() {
            return this.index;
        }

        public Object[] getElements() {
            return this.elements;
        }

        public Object getElement() {
            return this.elements[this.index];
        }

        public Object setElement(Object newElement) {
            Object old = this.elements[this.index];
            this.elements[this.index] = newElement;
            return old;
        }

        public Object[] getPreElements() {
            return this.preElements;
        }

        public Object[] getNextElements() {
            return this.nextElements;
        }
    }
}

