/*
 * Decompiled with CFR 0.152.
 */
package com.supalle.tools.code;

import com.supalle.tools.code.JavaCodeCompiler;
import com.supalle.tools.code.JdkCompiler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JavaCompilers {
    private static final ConcurrentMap<ClassLoader, JavaCodeCompiler> COMPILER_CACHE = new ConcurrentHashMap<ClassLoader, JavaCodeCompiler>();

    public static ConcurrentMap<ClassLoader, JavaCodeCompiler> getCompilerCache() {
        return COMPILER_CACHE;
    }

    public static JavaCodeCompiler getCompiler() {
        return JavaCompilers.getCompiler(null);
    }

    public static JavaCodeCompiler getCompiler(ClassLoader classLoader) {
        return JavaCompilers.getCompiler(classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaCodeCompiler getCompiler(ClassLoader classLoader, JdkCompiler jdkCompiler) {
        ClassLoader loader = classLoader != null ? classLoader : JavaCompilers.getDefaultClassLoader();
        JavaCodeCompiler javaCodeCompiler = (JavaCodeCompiler)COMPILER_CACHE.get(loader);
        if (javaCodeCompiler == null) {
            ConcurrentMap<ClassLoader, JavaCodeCompiler> concurrentMap = COMPILER_CACHE;
            synchronized (concurrentMap) {
                javaCodeCompiler = (JavaCodeCompiler)COMPILER_CACHE.get(loader);
                if (javaCodeCompiler != null) {
                    return javaCodeCompiler;
                }
                javaCodeCompiler = new JavaCodeCompiler(loader, jdkCompiler);
                COMPILER_CACHE.put(loader, javaCodeCompiler);
            }
        }
        return javaCodeCompiler;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classloader = null;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (classloader == null && (classloader = JavaCodeCompiler.class.getClassLoader()) == null) {
            try {
                classloader = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classloader;
    }
}

