/*
 * Decompiled with CFR 0.152.
 */
package com.supalle.tools.code;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JdkCompiler {
    public static final JdkCompiler INSTANCE = new JdkCompiler(new String[0]);
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final JavaFileManager javaFileManager;
    private final List<String> compilerArgs;

    public JdkCompiler(String ... compilerArgs) {
        this(compilerArgs == null ? null : Arrays.asList(compilerArgs));
    }

    public JdkCompiler(List<String> compilerArgs) {
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
        this.javaFileManager = new WrapperJavaFileManager(fileManager);
        if (compilerArgs == null || compilerArgs.isEmpty()) {
            compilerArgs = Arrays.asList("-source", "1.8", "-target", "1.8");
        }
        this.compilerArgs = compilerArgs;
    }

    public Map<String, byte[]> compileToClassBytes(String referenceName, String codeContent) {
        JavaCompiler.CompilationTask task;
        WrapperJavaFileObject wrapperJavaFileObject = new WrapperJavaFileObject(referenceName, codeContent);
        List<WrapperJavaFileObject> compilationUnits = Collections.singletonList(wrapperJavaFileObject);
        try (PrintWriter printWriter = new PrintWriter(new ByteArrayOutputStream());){
            task = this.compiler.getTask(printWriter, this.javaFileManager, null, this.compilerArgs, null, compilationUnits);
        }
        task.call();
        return Collections.unmodifiableMap(wrapperJavaFileObject.getOutClassBytesMap());
    }

    private static class WrapperJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        protected WrapperJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (kind == JavaFileObject.Kind.CLASS) {
                return new WrapperClassFileObject(className, (WrapperJavaFileObject)sibling);
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }
    }

    private static class WrapperClassFileObject
    extends SimpleJavaFileObject {
        private final String className;
        private final WrapperJavaFileObject wrapperJavaFileObject;

        public WrapperClassFileObject(String className, WrapperJavaFileObject wrapperJavaFileObject) {
            super(URI.create(className + ".class"), JavaFileObject.Kind.CLASS);
            this.className = className;
            this.wrapperJavaFileObject = wrapperJavaFileObject;
        }

        @Override
        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                @Override
                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    wrapperJavaFileObject.getOutClassBytesMap().put(className, bos.toByteArray());
                }
            };
        }
    }

    private static class WrapperJavaFileObject
    extends SimpleJavaFileObject {
        private final String referenceName;
        private final String codeContent;
        private Map<String, byte[]> outClassBytesMap = new LinkedHashMap<String, byte[]>();

        public WrapperJavaFileObject(String referenceName, String codeContent) {
            super(URI.create(referenceName.substring(referenceName.lastIndexOf(46) + 1) + ".java"), JavaFileObject.Kind.SOURCE);
            this.referenceName = referenceName;
            this.codeContent = codeContent;
        }

        @Override
        public CharBuffer getCharContent(boolean b) {
            return CharBuffer.wrap(this.codeContent);
        }

        public Map<String, byte[]> getOutClassBytesMap() {
            return this.outClassBytesMap;
        }

        public void setOutClassBytesMap(Map<String, byte[]> outClassBytesMap) {
            this.outClassBytesMap = outClassBytesMap;
        }
    }
}

