/*
 * Decompiled with CFR 0.152.
 */
package com.supalle.tools.code;

import com.supalle.tools.code.AbstractLinkedArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringJoiner;

public class LineList<E>
extends AbstractLinkedArrayList<E> {
    private Object[] headElements;
    private Object[] tailElements;
    private int size;
    private int lastIndex;
    private final int lineSize;

    public LineList() {
        this(11);
    }

    public LineList(int lineSize) {
        if (lineSize < 1) {
            throw new IllegalArgumentException("The LineList's line Size must be > 1");
        }
        this.lineSize = lineSize;
        this.clear();
    }

    public LineList(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public LineList(int lineSize, Collection<? extends E> collection) {
        this(lineSize);
        this.addAll(collection);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new LineListIterator(this.headElements);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        for (E e : this) {
            array[i++] = e;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int length;
        if (a == null || (length = a.length) == 0) {
            return this.toArray();
        }
        int i = 0;
        Object[] array = new Object[this.size];
        for (E e : this) {
            if (i >= length) break;
            array[i++] = e;
        }
        return array;
    }

    @Override
    public boolean add(E e) {
        this.checkSize();
        ++this.size;
        this.tailElements[this.lastIndex++] = e;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index;
        while ((index = this.indexOf(o)) != -1) {
            this.remove(index);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.isEmpty(c)) {
            return false;
        }
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkRange(index);
        int size = this.size;
        if (index == size) {
            for (E e : c) {
                this.add(e);
            }
        }
        List<E> suffixList = this.subList(index, size);
        this.limitOnIndex(index);
        for (Object e : c) {
            this.add(e);
        }
        for (Object e : suffixList) {
            this.add(e);
        }
        return false;
    }

    private void limitOnIndex(int index) {
        AbstractLinkedArrayList.ElementIndex elementIndex = this.findElementIndex(this.headElements, index);
        Object[] elements = elementIndex.getElements();
        int elementIndexIndex = elementIndex.getIndex();
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            if (i <= elementIndexIndex) continue;
            elements[i] = EMPTY_ELEMENT;
        }
        this.tailElements = elements;
        this.lastIndex = elementIndexIndex + 1;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.isEmpty(c)) {
            return false;
        }
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.isEmpty(c)) {
            this.clear();
            return false;
        }
        LineList retainItems = new LineList();
        for (Object o : c) {
            if (!this.contains(o)) continue;
            retainItems.add(o);
        }
        this.clear();
        return this.addAll(retainItems);
    }

    @Override
    public void clear() {
        this.headElements = this.newElements();
        this.tailElements = this.headElements;
        this.size = 0;
        this.lastIndex = 0;
    }

    @Override
    public E get(int index) {
        this.checkRange(index);
        AbstractLinkedArrayList.ElementIndex elementIndex = this.findElementIndex(this.headElements, index);
        return (E)elementIndex.getElement();
    }

    @Override
    public E set(int index, E element) {
        this.checkRange(index);
        AbstractLinkedArrayList.ElementIndex elementIndex = this.findElementIndex(this.headElements, index);
        return (E)elementIndex.setElement(element);
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size) {
            this.add(element);
            return;
        }
        this.checkRange(index);
        AbstractLinkedArrayList.ElementIndex elementIndex = this.findElementIndex(this.headElements, index);
        int elementIndexIndex = elementIndex.getIndex();
        Object[] elements = elementIndex.getElements();
        int length = elements.length;
        Object[] preElements = elementIndex.getPreElements();
        int subLength = length - elementIndexIndex;
        if (length <= this.lineSize) {
            Object[] newElements = LineList.newElements(length);
            if (elementIndexIndex > 0) {
                System.arraycopy(elements, 0, newElements, 0, elementIndexIndex);
            }
            newElements[elementIndexIndex] = element;
            System.arraycopy(elements, elementIndexIndex, newElements, elementIndexIndex + 1, subLength);
            this.linkElements(preElements, newElements);
            if (elements == this.tailElements) {
                ++this.lastIndex;
            }
        } else {
            Object[] newElements = LineList.newElements(1);
            if (elementIndexIndex == 0) {
                newElements[0] = element;
                newElements[1] = elements;
                this.linkElements(preElements, newElements);
            } else {
                int nextElementIndex = LineList.getNextElementIndex(elements);
                newElements[0] = elements[nextElementIndex - 1];
                newElements[1] = elements[nextElementIndex];
                System.arraycopy(elements, elementIndexIndex, elements, elementIndexIndex + 1, subLength - 1);
                elements[elementIndexIndex] = element;
                elements[nextElementIndex] = newElements;
                if (elements == this.tailElements) {
                    this.lastIndex = 1;
                }
            }
        }
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.checkRange(index);
        AbstractLinkedArrayList.ElementIndex elementIndex = this.findElementIndex(this.headElements, index);
        Object[] elements = elementIndex.getElements();
        Object[] preElements = elementIndex.getPreElements();
        Object oldVal = elementIndex.getElement();
        if (this.isSingleElement(elements)) {
            Object[] nextElements = elementIndex.getNextElements();
            int nextElementIndex = LineList.getNextElementIndex(preElements);
            Object[] objectArray = preElements[nextElementIndex] = nextElements == null ? EMPTY_ELEMENT : nextElements;
            if (elements == this.tailElements) {
                this.lastIndex = nextElementIndex;
            }
        } else {
            int length = elements.length;
            int elementIndexIndex = elementIndex.getIndex();
            Object[] newElements = LineList.newElements(length - 2);
            if (elementIndexIndex > 0) {
                System.arraycopy(elements, 0, newElements, 0, elementIndexIndex);
            }
            int subSuffixLength = length - elementIndexIndex - 1;
            System.arraycopy(elements, elementIndexIndex + 1, newElements, elementIndexIndex, subSuffixLength);
            preElements[LineList.getNextElementIndex((Object[])preElements)] = newElements;
            if (elements == this.tailElements) {
                --this.lastIndex;
            }
        }
        --this.size;
        return (E)oldVal;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            for (E e : this) {
                if (e == null) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
        for (E e : this) {
            if (o.equals(e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = 0;
        int result = -1;
        if (o == null) {
            for (E e : this) {
                if (e == null) {
                    result = index;
                }
                ++index;
            }
            return result;
        }
        for (E e : this) {
            if (o.equals(e)) {
                result = index;
            }
            ++index;
        }
        return result;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int size = this.size;
        LineList.subListRangeCheck(fromIndex, toIndex, size);
        int subLength = toIndex - fromIndex;
        LineList<E> subList = new LineList<E>();
        if (subLength == 0) {
            return subList;
        }
        int index = 0;
        for (E e : this) {
            if (index >= toIndex) break;
            if (index < fromIndex) continue;
            subList.add(e);
        }
        return subList;
    }

    static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("size:" + size + ",sub list range:0~" + size + ",fromIndex:" + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("size:" + size + ",sub list range:0~" + size + ",toIndex:" + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
        for (E e : this) {
            stringJoiner.add(String.valueOf(e));
        }
        return stringJoiner.toString();
    }

    private void checkSize() {
        int nextElementIndex = LineList.getNextElementIndex(this.tailElements);
        if (this.lastIndex == nextElementIndex) {
            Object[] newElements;
            this.tailElements[this.lastIndex] = newElements = this.newElements();
            this.tailElements = newElements;
            this.lastIndex = 0;
        }
    }

    private static int getNextElementIndex(Object[] elements) {
        return elements.length - 1;
    }

    private void linkElements(Object[] preElements, Object[] newElements) {
        if (preElements == null) {
            this.headElements = newElements;
        } else {
            preElements[LineList.getNextElementIndex((Object[])preElements)] = newElements;
        }
    }

    private boolean isSingleElement(Object[] elements) {
        return elements.length == 2;
    }

    private Object[] newElements() {
        return LineList.newElements(this.lineSize);
    }

    private static Object[] newElements(int size) {
        int elementLineSize = size + 1;
        Object[] newElements = new Object[elementLineSize];
        for (int i = 0; i < elementLineSize; ++i) {
            newElements[i] = EMPTY_ELEMENT;
        }
        return newElements;
    }

    private static Object[] compressElements(Object[] elements) {
        int emptySize = 0;
        int nextElementIndex = LineList.getNextElementIndex(elements);
        for (int i = 0; i < nextElementIndex; ++i) {
            if (elements[i] != EMPTY_ELEMENT) continue;
            ++emptySize;
        }
        if (emptySize == 0) {
            return elements;
        }
        Object[] newElements = LineList.newElements(nextElementIndex - emptySize);
        for (int i = 0; i < nextElementIndex; ++i) {
            if (elements[i] != EMPTY_ELEMENT) continue;
            ++emptySize;
        }
        newElements[LineList.getNextElementIndex((Object[])newElements)] = elements[nextElementIndex];
        return newElements;
    }

    private AbstractLinkedArrayList.ElementIndex findElementIndex(Object[] elements, int index) {
        int nextElementIndex = LineList.getNextElementIndex(elements);
        Object[] preElements = null;
        while (index >= nextElementIndex) {
            preElements = elements;
            elements = (Object[])elements[nextElementIndex];
            index -= nextElementIndex;
            nextElementIndex = LineList.getNextElementIndex(elements);
        }
        Object nextElements = elements[LineList.getNextElementIndex(elements)];
        boolean hasNextElements = nextElements != EMPTY_ELEMENT;
        return new AbstractLinkedArrayList.ElementIndex(index, elements, preElements, hasNextElements ? (Object[])nextElements : null);
    }

    private void checkRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("size:" + this.size + ",range:0~" + (this.size - 1) + ",index:" + index);
        }
    }

    private Iterator<E> vanishIterator() {
        return new VanishLineListIterator();
    }

    public static <E> Iterator<E> vanishIterator(Iterable<E> lineList) {
        if (lineList == null) {
            return Collections.emptyIterator();
        }
        if (lineList instanceof LineList) {
            return ((LineList)lineList).vanishIterator();
        }
        return lineList.iterator();
    }

    public static <E> LineList<E> of(E ... e) {
        LineList<E> lineList = new LineList<E>();
        return LineList.of(lineList, e);
    }

    public static <E> LineList<E> of(LineList<E> lineList, E ... e) {
        if (lineList == null) {
            lineList = new LineList<E>();
        }
        if (e != null && e.length > 0) {
            for (E item : e) {
                lineList.add(item);
            }
        }
        return lineList;
    }

    public static <E> LineList<E> of(Collection<? extends E> collection) {
        return new LineList<E>(collection);
    }

    public static <E> LineList<E> of(Collection<? extends E> collection, int lineSize) {
        return new LineList<E>(lineSize, collection);
    }

    public static <E> LineList<E> vanishOf(Collection<? extends E> collection) {
        LineList<E> lineList = new LineList<E>();
        return LineList.vanishAddAll(lineList, collection);
    }

    public static <E> LineList<E> vanishOf(int lineSize, Collection<? extends E> collection) {
        LineList<E> lineList = new LineList<E>(lineSize);
        return LineList.vanishAddAll(lineList, collection);
    }

    public static <E> LineList<E> vanishAddAll(LineList<E> lineList, Collection<? extends E> collection) {
        if (lineList == null) {
            lineList = new LineList<E>();
        }
        if (lineList == collection) {
            collection = new LineList<E>(collection);
        }
        Iterator<E> vanishIterator = LineList.vanishIterator(collection);
        while (vanishIterator.hasNext()) {
            lineList.add(vanishIterator.next());
        }
        return lineList;
    }

    static /* synthetic */ Object[] access$102(LineList x0, Object[] x1) {
        x0.headElements = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$202(LineList x0, Object[] x1) {
        x0.tailElements = x1;
        return x1;
    }

    class VanishLineListIterator<E>
    implements Iterator<E> {
        private int inx = 0;

        VanishLineListIterator() {
        }

        @Override
        public boolean hasNext() {
            return LineList.this.headElements[this.inx] != AbstractLinkedArrayList.EMPTY_ELEMENT;
        }

        @Override
        public E next() {
            int inx;
            Object[] elements = LineList.this.headElements;
            Object element = elements[inx = this.inx];
            if (element == AbstractLinkedArrayList.EMPTY_ELEMENT) {
                LineList.access$102(LineList.this, null);
                LineList.access$202(LineList.this, null);
                return null;
            }
            elements[inx] = null;
            int nextElementIndex = LineList.getNextElementIndex(elements);
            if (inx >= nextElementIndex) {
                elements = (Object[])element;
                inx = 0;
                element = elements[inx];
                LineList.access$102(LineList.this, elements);
                elements[inx] = null;
            }
            this.inx = ++inx;
            return (E)element;
        }
    }

    static class LineListIterator<E>
    implements Iterator<E> {
        private Object[] headElements;
        private int inx = 0;

        LineListIterator(Object[] headElements) {
            this.headElements = headElements;
        }

        @Override
        public boolean hasNext() {
            return this.headElements[this.inx] != AbstractLinkedArrayList.EMPTY_ELEMENT;
        }

        @Override
        public E next() {
            Object[] elements = this.headElements;
            int inx = this.inx;
            Object element = elements[inx];
            if (element == AbstractLinkedArrayList.EMPTY_ELEMENT) {
                return null;
            }
            int nextElementIndex = LineList.getNextElementIndex(elements);
            if (inx >= nextElementIndex) {
                elements = (Object[])element;
                inx = 0;
                element = elements[inx];
                this.headElements = elements;
            }
            this.inx = ++inx;
            return (E)element;
        }
    }
}

