/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot.api;

import com.syncthemall.diffbot.api.DiffbotAPI;
import com.syncthemall.diffbot.api.Request;
import com.syncthemall.diffbot.exception.DiffbotAPIException;
import com.syncthemall.diffbot.exception.DiffbotException;
import com.syncthemall.diffbot.exception.DiffbotIOException;
import com.syncthemall.diffbot.exception.DiffbotParseException;
import com.syncthemall.diffbot.exception.DiffbotServerException;
import com.syncthemall.diffbot.exception.DiffbotUnauthorizedException;
import java.io.Serializable;

public class Future<T>
implements Serializable {
    private static final long serialVersionUID = 6079999701417072567L;
    private Request request;
    private T result;
    private DiffbotException error;
    private DiffbotAPI callback;
    private boolean executed = false;

    protected Future(Request request, DiffbotAPI callback) {
        this.request = request;
        this.callback = callback;
    }

    protected final Request getRequest() {
        return this.request;
    }

    protected final Future<T> setResult(T result) {
        this.result = result;
        return this;
    }

    protected final Future<T> setExecuted(boolean executed) {
        this.executed = executed;
        return this;
    }

    protected final Future<T> setError(DiffbotException error) {
        this.error = error;
        return this;
    }

    public final T get() throws DiffbotAPIException, DiffbotIOException, DiffbotUnauthorizedException, DiffbotServerException, DiffbotParseException {
        if (!this.executed) {
            this.callback.executeBatch(this);
        }
        if (this.error != null) {
            if (this.error instanceof DiffbotAPIException) {
                throw (DiffbotAPIException)this.error;
            }
            if (this.error instanceof DiffbotIOException) {
                throw (DiffbotIOException)this.error;
            }
            if (this.error instanceof DiffbotParseException) {
                throw (DiffbotParseException)this.error;
            }
            if (this.error instanceof DiffbotServerException) {
                throw (DiffbotServerException)this.error;
            }
            if (this.error instanceof DiffbotUnauthorizedException) {
                throw (DiffbotUnauthorizedException)this.error;
            }
        }
        return this.result;
    }
}

