/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.syncthemall.diffbot.Diffbot;
import com.syncthemall.diffbot.Future;
import com.syncthemall.diffbot.exception.DiffbotAPIException;
import com.syncthemall.diffbot.exception.DiffbotException;
import com.syncthemall.diffbot.exception.DiffbotParseException;
import com.syncthemall.diffbot.exception.DiffbotServerException;
import com.syncthemall.diffbot.exception.DiffbotUnauthorizedException;
import com.syncthemall.diffbot.exception.JAXBInitializationException;
import com.syncthemall.diffbot.exception.UnknownRequestAPITypeException;
import com.syncthemall.diffbot.model.Model;
import com.syncthemall.diffbot.model.article.Article;
import com.syncthemall.diffbot.model.batch.BatchRequest;
import com.syncthemall.diffbot.model.batch.BatchResponse;
import com.syncthemall.diffbot.model.classifier.Classified;
import com.syncthemall.diffbot.model.frontpage.Frontpage;
import com.syncthemall.diffbot.model.images.Images;
import com.syncthemall.diffbot.model.products.Products;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public abstract class DiffbotRequest<T extends Model>
extends GenericUrl {
    private ResourceBundle bundle = ResourceBundle.getBundle("com.syncthemall.diffbot.messages.Messages");
    private HttpRequestFactory requestFactory;
    private List<Future<? extends Model>> futures;
    private JAXBContext jc;
    private JsonFactory jsonFactory;
    private Class<T> responseClass;
    private int maxBatchRequest = 20;
    private int batchRequestTimeout = 360000;
    private int readTimeout = 20000;

    public DiffbotRequest(Diffbot client, Class<T> responseClass, String encodedUrl) {
        super(encodedUrl);
        this.requestFactory = client.getRequestFactory();
        this.jc = client.getJAXBContext();
        this.jsonFactory = client.getJsonFactory();
        this.futures = client.getFutures();
        this.responseClass = responseClass;
        this.maxBatchRequest = client.getMaxBatchRequest();
        this.batchRequestTimeout = client.getBatchRequestTimeout();
    }

    protected abstract ApiType getApiType();

    public final T execute() throws DiffbotException {
        try {
            HttpRequest request = this.requestFactory.buildGetRequest((GenericUrl)this);
            request.setReadTimeout(this.readTimeout);
            HttpResponse response = request.execute();
            if (this.responseClass.equals(Frontpage.class)) {
                return this.executeFrontpage(response);
            }
            return this.executeModel(response);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 401) {
                throw new DiffbotUnauthorizedException(this.bundle.getString("token.not.authorized"));
            }
            throw new DiffbotServerException(e.getStatusCode(), e.getStatusMessage());
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("request.not.executed"), e);
        }
    }

    private T executeFrontpage(HttpResponse response) throws DiffbotAPIException, DiffbotParseException, DiffbotServerException {
        if (response.getContentType() != null && !response.getContentType().isEmpty() && response.getContentType().contains("application/json")) {
            try {
                GenericJson error = (GenericJson)response.parseAs(GenericJson.class);
                BigDecimal errorCode = (BigDecimal)error.get((Object)"statusCode");
                throw new DiffbotAPIException(errorCode.intValue(), (String)error.get((Object)"message"));
            }
            catch (IOException e) {
                throw new DiffbotParseException(this.bundle.getString("frontpage.error.not.parsed"), e);
            }
        }
        try {
            return (T)((Object)((Model)((Object)this.createUnmarshaller().unmarshal(response.getContent()))));
        }
        catch (JAXBException e) {
            throw new DiffbotParseException(this.bundle.getString("dml.not.parsed"), e);
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("response.not.read"), e);
        }
    }

    private T executeModel(HttpResponse response) throws DiffbotAPIException, DiffbotParseException {
        try {
            GenericJson result = (GenericJson)response.parseAs(this.responseClass);
            BigDecimal errorCode = (BigDecimal)result.get((Object)"errorCode");
            if (errorCode != null) {
                throw new DiffbotAPIException(errorCode.intValue(), (String)result.get((Object)"error"));
            }
            return (T)((Object)((Model)result));
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("response.not.parsed"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<T> queue() {
        Future future = new Future(this);
        List<Future<? extends Model>> list = this.futures;
        synchronized (list) {
            this.futures.add(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runBatch(Future<T> initiator) throws DiffbotUnauthorizedException, DiffbotServerException, DiffbotParseException {
        if (this.futures.contains(initiator)) {
            ArrayList<Future<? extends Model>> batchList = new ArrayList<Future<? extends Model>>();
            List<Future<? extends Model>> list = this.futures;
            synchronized (list) {
                batchList.add(initiator);
                this.futures.remove(initiator);
                int batchSize = this.futures.size() > this.maxBatchRequest - 1 ? this.maxBatchRequest - 1 : this.futures.size();
                List<Future<? extends Model>> subList = this.futures.subList(0, batchSize);
                batchList.addAll(subList);
                subList.clear();
            }
            try {
                BatchResponse[] responses = this.executeBatchRequest(batchList);
                this.parseBatchResponses(responses, batchList);
            }
            catch (DiffbotServerException | DiffbotUnauthorizedException e) {
                List<Future<? extends Model>> list2 = this.futures;
                synchronized (list2) {
                    this.futures.addAll(batchList);
                }
                throw e;
            }
        }
    }

    private BatchResponse[] executeBatchRequest(Collection<Future<? extends Model>> futureRequests) throws DiffbotUnauthorizedException, DiffbotServerException, DiffbotParseException {
        ArrayList<BatchRequest> requests = new ArrayList<BatchRequest>();
        GenericUrl batchUrl = new GenericUrl("http://www.diffbot.com/api/batch");
        for (Future<? extends Model> future : futureRequests) {
            requests.add(new BatchRequest("GET", future.getRequest().buildRelativeUrl()));
        }
        batchUrl.set("batch", (Object)this.buildBatchQuery(requests));
        try {
            HttpRequest request = this.requestFactory.buildPostRequest(batchUrl, null);
            request.setReadTimeout(this.batchRequestTimeout);
            HttpResponse response = request.execute();
            if (response.getStatusCode() == 401) {
                throw new DiffbotUnauthorizedException(this.bundle.getString("token.not.authorized"));
            }
            if (response.getStatusCode() != 200) {
                throw new DiffbotServerException(response.getStatusCode(), response.getStatusMessage());
            }
            return this.parseBatchResponse(response);
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("request.not.executed"), e);
        }
    }

    private String buildBatchQuery(List<BatchRequest> requests) throws DiffbotParseException {
        try {
            return this.jsonFactory.toString(requests);
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("batch.request.not.built"), e);
        }
    }

    private BatchResponse[] parseBatchResponse(HttpResponse response) throws DiffbotServerException {
        try {
            return (BatchResponse[])response.parseAs(BatchResponse[].class);
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("response.not.parsed"), e);
        }
    }

    private void parseBatchResponses(BatchResponse[] responses, List<Future<? extends Model>> results) {
        for (int i = 0; i < responses.length; ++i) {
            String responseContent = responses[i].getBody();
            for (Future<? extends Model> future : results) {
                if (!future.getRequest().buildRelativeUrl().equals(responses[i].getRelativeUrl()) || future.isExecuted()) continue;
                Future<? extends Model> result = future;
                try {
                    if (responses[i].getCode() != 200) {
                        throw new DiffbotServerException(responses[i].getCode(), responseContent);
                    }
                    if (responses[i].getHeaders().length == 0) {
                        throw new DiffbotParseException(this.bundle.getString("batch.response.no.header"));
                    }
                    if (result.getRequest().getApiType() != ApiType.FRONTPAGE) {
                        this.parseModelBatchResponses(responses[i], result);
                        continue;
                    }
                    this.parseFrontpageBatchResponses(responses[i], result);
                }
                catch (DiffbotAPIException | DiffbotParseException | DiffbotServerException e) {
                    result.setError(e).setExecuted(true);
                }
            }
        }
    }

    private void parseModelBatchResponses(BatchResponse response, Future<? extends Model> result) throws DiffbotParseException, DiffbotAPIException {
        if (response.getFirstHeader("Content-Type") == null || response.getFirstHeader("Content-Type").getValue() == null) {
            throw new DiffbotParseException(this.bundle.getString("batch.response.no.contenttype"));
        }
        try {
            Model model;
            if (result.getRequest().getApiType() == ApiType.ARTICLE) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Article.class, null));
            } else if (result.getRequest().getApiType() == ApiType.IMAGE) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Images.class, null));
            } else if (result.getRequest().getApiType() == ApiType.PRODUCT) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Products.class, null));
            } else if (result.getRequest().getApiType() == ApiType.CLASSIFIER) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Classified.class, null));
            } else {
                throw new UnknownRequestAPITypeException(this.bundle.getString("batch.unknow.type"), result.getRequest().getApiType());
            }
            result.setResult(model).setExecuted(true);
            BigDecimal errorCode = (BigDecimal)model.get("errorCode");
            if (errorCode != null) {
                throw new DiffbotAPIException(errorCode.intValue(), (String)model.get("error"));
            }
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("model.not.parsed"), e);
        }
    }

    private void parseFrontpageBatchResponses(BatchResponse response, Future<? extends Model> result) throws DiffbotAPIException, DiffbotParseException {
        try {
            if (response.getFirstHeader("Content-Type") != null && response.getFirstHeader("Content-Type").getValue() != null && response.getFirstHeader("Content-Type").getValue().contains("application/json")) {
                GenericJson error = (GenericJson)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(GenericJson.class, null);
                BigDecimal errorCode = (BigDecimal)error.get((Object)"statusCode");
                throw new DiffbotAPIException(errorCode.intValue(), (String)error.get((Object)"message"));
            }
            Frontpage frontpage = (Frontpage)this.createUnmarshaller().unmarshal((Reader)new StringReader(response.getBody()));
            result.setResult(frontpage).setExecuted(true);
        }
        catch (JAXBException e) {
            throw new DiffbotParseException(this.bundle.getString("dml.not.parsed"), e);
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("frontpage.error.not.parsed"), e);
        }
    }

    private Unmarshaller createUnmarshaller() {
        try {
            return this.jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new JAXBInitializationException(this.bundle.getString("jaxb.not.instanciated"), e);
        }
    }

    protected final void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public static enum ApiType {
        ARTICLE,
        FRONTPAGE,
        IMAGE,
        PRODUCT,
        CLASSIFIER;

    }
}

