/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot;

import com.syncthemall.diffbot.DiffbotRequest;
import com.syncthemall.diffbot.exception.DiffbotAPIException;
import com.syncthemall.diffbot.exception.DiffbotException;
import com.syncthemall.diffbot.exception.DiffbotParseException;
import com.syncthemall.diffbot.exception.DiffbotServerException;
import com.syncthemall.diffbot.exception.DiffbotUnauthorizedException;
import com.syncthemall.diffbot.model.Model;

public class Future<T extends Model> {
    private DiffbotRequest<T> request;
    private Model result;
    private DiffbotException error;
    private boolean executed = false;

    protected Future(DiffbotRequest<T> request) {
        this.request = request;
    }

    protected final DiffbotRequest<T> getRequest() {
        return this.request;
    }

    protected final Future<T> setResult(Model result) {
        this.result = result;
        this.executed = true;
        return this;
    }

    protected final Future<T> setError(DiffbotException error) {
        this.error = error;
        this.executed = true;
        return this;
    }

    protected final boolean isExecuted() {
        return this.executed;
    }

    public final T get() throws DiffbotException {
        if (!this.executed) {
            this.request.runBatch(this);
        }
        if (this.error != null) {
            if (this.error instanceof DiffbotAPIException) {
                throw (DiffbotAPIException)this.error;
            }
            if (this.error instanceof DiffbotParseException) {
                throw (DiffbotParseException)this.error;
            }
            if (this.error instanceof DiffbotServerException) {
                throw (DiffbotServerException)this.error;
            }
            if (this.error instanceof DiffbotUnauthorizedException) {
                throw (DiffbotUnauthorizedException)this.error;
            }
        }
        return (T)((Object)this.result);
    }
}

