/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.ArgumentSerializer;
import com.syntaxphoenix.syntaxapi.command.ArgumentSuperType;
import com.syntaxphoenix.syntaxapi.command.ArgumentType;
import com.syntaxphoenix.syntaxapi.command.BaseArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ListArgument;
import com.syntaxphoenix.syntaxapi.exception.ObjectLockedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Arguments
implements Iterable<BaseArgument> {
    private final List<BaseArgument> arguments;
    private boolean locked = false;

    public Arguments() {
        this.arguments = new ArrayList<BaseArgument>();
    }

    public Arguments(List<BaseArgument> arguments) {
        this.arguments = arguments;
    }

    public int count() {
        return this.arguments.size();
    }

    public BaseArgument get(int position) {
        if (position < 1) {
            throw this.negativeOrZero();
        }
        if (position > this.count()) {
            throw this.outOfBounce(position);
        }
        return this.arguments.get(position - 1);
    }

    public void add(BaseArgument argument, int position) {
        if (this.locked) {
            throw this.locked();
        }
        if (position < 1) {
            throw this.negativeOrZero();
        }
        if (argument == null) {
            return;
        }
        this.arguments.add(position - 1, argument);
    }

    public void add(BaseArgument argument) {
        if (this.locked) {
            throw this.locked();
        }
        if (argument == null) {
            return;
        }
        this.arguments.add(argument);
    }

    public ArgumentType getType(int position) {
        return this.get(position).getType();
    }

    public ArgumentSuperType getSuperType(int position) {
        return this.getType(position).getSuperType();
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String toString() {
        return this.toString(ArgumentSerializer.DEFAULT);
    }

    public String toString(int start) {
        return this.toString(start, this.arguments.size());
    }

    public String toString(int start, int end) {
        return this.toString(start, end, ArgumentSerializer.DEFAULT);
    }

    public String toString(ArgumentSerializer serializer) {
        return new ListArgument<BaseArgument>(this.arguments).toString(serializer);
    }

    public String toString(int start, ArgumentSerializer serializer) {
        return this.toString(start, serializer);
    }

    public String toString(int start, int end, ArgumentSerializer serializer) {
        return new ListArgument<BaseArgument>(this.arguments.subList(start, end)).toString(serializer);
    }

    private IllegalArgumentException negativeOrZero() {
        return new IllegalArgumentException("Bound must be positive!");
    }

    private IndexOutOfBoundsException outOfBounce(int position) {
        return new IndexOutOfBoundsException("Index: " + position + " - Size: " + this.count());
    }

    private ObjectLockedException locked() {
        return new ObjectLockedException("Cannot edit a locked object!");
    }

    @Override
    public Iterator<BaseArgument> iterator() {
        return this.arguments.iterator();
    }

    public Arguments copy(int start) {
        return this.copy(start, this.arguments.size());
    }

    public Arguments copy(int start, int end) {
        return new Arguments(this.arguments.subList(start, end));
    }
}

