/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.ArgumentIdentifier;
import com.syntaxphoenix.syntaxapi.command.Arguments;
import com.syntaxphoenix.syntaxapi.command.BaseCommand;
import com.syntaxphoenix.syntaxapi.command.BaseInfo;
import com.syntaxphoenix.syntaxapi.command.CommandProcess;
import com.syntaxphoenix.syntaxapi.command.DefaultInfo;
import com.syntaxphoenix.syntaxapi.command.ExecutionState;
import com.syntaxphoenix.syntaxapi.logging.SynLogger;
import com.syntaxphoenix.syntaxapi.utils.alias.Alias;
import com.syntaxphoenix.syntaxapi.utils.alias.AliasMap;
import com.syntaxphoenix.syntaxapi.utils.java.Arrays;
import java.util.Map;
import java.util.function.BiFunction;

public class CommandManager {
    private BiFunction<CommandManager, String, ? extends BaseInfo> infoConstructor = (manager, label) -> new DefaultInfo((CommandManager)manager, (String)label);
    private final AliasMap<BaseCommand> commands = new AliasMap();
    private ArgumentIdentifier validator = ArgumentIdentifier.DEFAULT;
    private SynLogger logger = null;
    private String splitter = " ";
    private String prefix = "!";

    public AliasMap<BaseCommand> getClonedMap() {
        return this.commands.clone();
    }

    public Map.Entry<Alias, BaseCommand>[] getEntries() {
        return this.commands.entrySet().toArray(new Map.Entry[0]);
    }

    public BaseCommand[] getCommands() {
        return this.commands.values().toArray(new BaseCommand[0]);
    }

    public Alias[] getAliases() {
        return this.commands.keySet().toArray(new Alias[0]);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public CommandManager setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public CommandManager setSplitter(String splitter) {
        this.splitter = splitter;
        return this;
    }

    public BiFunction<CommandManager, String, ? extends BaseInfo> getInfoConstructor() {
        return this.infoConstructor;
    }

    public CommandManager setInfoConstructor(BiFunction<CommandManager, String, ? extends BaseInfo> infoConstructor) {
        this.infoConstructor = infoConstructor;
        return this;
    }

    public ArgumentIdentifier getValidator() {
        return this.validator;
    }

    public CommandManager setValidator(ArgumentIdentifier validator) {
        this.validator = validator;
        return this;
    }

    public CommandManager setLogger(SynLogger logger) {
        this.logger = logger;
        return this;
    }

    public boolean hasLogger() {
        return this.logger != null;
    }

    public SynLogger getLogger() {
        return this.logger;
    }

    public CommandManager register(BaseCommand command, String name, String ... aliases) {
        return this.register(command, new Alias(name, aliases));
    }

    public CommandManager register(BaseCommand command, String description, String name, String[] aliases) {
        return this.register(command, new Alias(name, aliases).setDescription(description));
    }

    public CommandManager register(BaseCommand command, Alias alias) {
        if (this.commands.hasConflict(alias).isEmpty()) {
            this.commands.put(alias, (Object)command);
        }
        return this;
    }

    public CommandProcess process(String message) {
        CommandProcess process = new CommandProcess(this);
        if (!message.startsWith(this.prefix) || message.equals(this.prefix)) {
            return process.lock();
        }
        return this.process(message.replace(this.prefix, "").split(this.splitter));
    }

    public CommandProcess process(String ... message) {
        return this.process(new CommandProcess(this), message);
    }

    private CommandProcess process(CommandProcess process, String ... message) {
        String command = message[0].toLowerCase();
        process.setLabel(command);
        if (command.isEmpty()) {
            return process.lock();
        }
        process.setValid(true);
        if (!this.commands.containsKey(command)) {
            return process.lock();
        }
        process.setCommand((BaseCommand)this.commands.get(command));
        process.setArguments(new Arguments(this.validator.process((String[])Arrays.subArray(String[]::new, (Object[])message, (int)1))));
        return process.lock();
    }

    public ExecutionState execute(String message) {
        return this.process(message).execute();
    }

    public ExecutionState execute(CommandProcess process) {
        ExecutionState state = process.asState();
        if (!state.isRunnable()) {
            return state;
        }
        return this.execute(process.getCommand(), process.constructInfo(), process.getArguments());
    }

    public ExecutionState execute(BaseCommand command, BaseInfo info, Arguments arguments) {
        try {
            command.execute(info, arguments);
        }
        catch (Throwable throwable) {
            if (this.hasLogger()) {
                this.logger.log(throwable);
            }
            return ExecutionState.FAILED;
        }
        return ExecutionState.SUCCESS;
    }
}

