/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.Arguments;
import com.syntaxphoenix.syntaxapi.command.BaseCommand;
import com.syntaxphoenix.syntaxapi.command.BaseInfo;
import com.syntaxphoenix.syntaxapi.command.CommandManager;
import com.syntaxphoenix.syntaxapi.command.ExecutionState;
import com.syntaxphoenix.syntaxapi.exception.ObjectLockedException;
import java.util.function.BiFunction;

public class CommandProcess {
    private final CommandManager manager;
    private BiFunction<CommandManager, String, ? extends BaseInfo> infoConstructor;
    private boolean locked = false;
    private boolean valid = false;
    private BaseCommand command;
    private Arguments arguments;
    private String label;

    public CommandProcess(CommandManager manager) {
        this.manager = manager;
        this.infoConstructor = manager.getInfoConstructor();
    }

    public CommandProcess setValid(boolean valid) {
        if (this.isLocked()) {
            throw this.locked();
        }
        this.valid = valid;
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    public CommandProcess setLabel(String label) {
        if (this.isLocked()) {
            throw this.locked();
        }
        this.label = label;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public CommandProcess setCommand(BaseCommand command) {
        if (this.isLocked()) {
            throw this.locked();
        }
        this.command = command;
        return this;
    }

    public BaseCommand getCommand() {
        return this.command;
    }

    public CommandProcess setArguments(Arguments arguments) {
        if (this.isLocked()) {
            throw this.locked();
        }
        this.arguments = arguments;
        return this;
    }

    public Arguments getArguments() {
        return this.arguments;
    }

    public CommandProcess setInfoConstructor(BiFunction<CommandManager, String, ? extends BaseInfo> info) {
        this.infoConstructor = info;
        return this;
    }

    public BaseInfo constructInfo() {
        return this.infoConstructor.apply(this.manager, this.label == null ? "" : this.label);
    }

    public ExecutionState asState() {
        return this.isValid() ? (this.command == null ? ExecutionState.NOT_EXISTENT : ExecutionState.READY) : ExecutionState.NO_COMMAND;
    }

    public ExecutionState execute() {
        return this.execute(this.manager);
    }

    public ExecutionState execute(CommandManager manager) {
        if (!this.arguments.isLocked()) {
            this.arguments.setLocked(true);
        }
        return manager.execute(this);
    }

    public CommandProcess lock() {
        if (!this.isLocked()) {
            this.locked = true;
        }
        return this;
    }

    public boolean isLocked() {
        return this.locked;
    }

    private ObjectLockedException locked() {
        return new ObjectLockedException("Cannot edit a locked object!");
    }
}

