/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command.range;

import com.syntaxphoenix.syntaxapi.command.ArgumentRangeSerializer;
import com.syntaxphoenix.syntaxapi.command.BaseArgument;
import com.syntaxphoenix.syntaxapi.command.BaseArgumentRange;
import com.syntaxphoenix.syntaxapi.command.RangeType;
import com.syntaxphoenix.syntaxapi.command.range.NumberValueRange;
import java.util.Collection;

public class CollectionSizeRange<T>
extends BaseArgumentRange {
    private final int minimum;
    private final int maximum;
    private final Class<T> type;

    public CollectionSizeRange(int minimum, int maximum, Class<T> type) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.type = type;
    }

    public CollectionSizeRange(NumberValueRange number, Class<T> type) {
        this.minimum = number.getMinimum().intValue();
        this.maximum = number.getMaximum().intValue();
        this.type = type;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public RangeType getType() {
        return RangeType.COLLECTION_SIZE_RANGE;
    }

    @Override
    public Class<?> getInputType() {
        return this.getType().getInputType();
    }

    @Override
    public boolean hasType(BaseArgument argument) {
        return argument.getClassType().isAssignableFrom(this.getInputType());
    }

    @Override
    public boolean isInRange(BaseArgument argument) {
        Object object;
        if (!this.hasType(argument)) {
            return false;
        }
        Collection collection = (Collection)argument.asObject();
        int length = collection.size();
        if (length != 0 && !this.type.isInstance(object = collection.iterator().next())) {
            return false;
        }
        return length >= this.minimum && length <= this.maximum;
    }

    @Override
    public String toString() {
        return this.toString(ArgumentRangeSerializer.DEFAULT);
    }

    @Override
    public String toString(ArgumentRangeSerializer serializer) {
        return serializer.toString(this);
    }
}

