/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.ArgumentType;
import com.syntaxphoenix.syntaxapi.command.BaseArgument;
import com.syntaxphoenix.syntaxapi.command.DefaultArgumentSerializer;
import com.syntaxphoenix.syntaxapi.command.arguments.ArrayArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.BigDecimalArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.BigIntegerArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.BooleanArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ByteArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.DoubleArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.FloatArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.IntegerArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ListArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.LongArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.ShortArgument;
import com.syntaxphoenix.syntaxapi.command.arguments.StringArgument;

public abstract class ArgumentSerializer {
    public static final ArgumentSerializer DEFAULT = new DefaultArgumentSerializer();

    public String toString(BaseArgument argument) {
        ArgumentType type = argument.getType();
        String output = "";
        switch (type) {
            case BOOLEAN: {
                output = this.toString(argument.asBoolean());
                break;
            }
            case BYTE: {
                output = this.toString(argument.asByte());
                break;
            }
            case SHORT: {
                output = this.toString(argument.asShort());
                break;
            }
            case ARRAY: {
                output = this.toString(argument.asArray());
                break;
            }
            case BIG_INTEGER: {
                output = this.toString(argument.asBigInteger());
                break;
            }
            case BIG_DECIMAL: {
                output = this.toString(argument.asBigDecimal());
                break;
            }
            case DOUBLE: {
                output = this.toString(argument.asDouble());
                break;
            }
            case FLOAT: {
                output = this.toString(argument.asFloat());
                break;
            }
            case INTEGER: {
                output = this.toString(argument.asInteger());
                break;
            }
            case LIST: {
                output = this.toString(argument.asList());
                break;
            }
            case LONG: {
                output = this.toString(argument.asLong());
                break;
            }
            case STRING: {
                output = this.toString(argument.asString());
                break;
            }
            case CUSTOM: {
                output = argument.asObject().toString();
            }
        }
        return output;
    }

    public abstract String toString(ArrayArgument<BaseArgument> var1);

    public abstract String toString(BigDecimalArgument var1);

    public abstract String toString(BigIntegerArgument var1);

    public abstract String toString(DoubleArgument var1);

    public abstract String toString(ByteArgument var1);

    public abstract String toString(ShortArgument var1);

    public abstract String toString(FloatArgument var1);

    public abstract String toString(IntegerArgument var1);

    public abstract String toString(ListArgument<BaseArgument> var1);

    public abstract String toString(LongArgument var1);

    public abstract String toString(StringArgument var1);

    public abstract String toString(BooleanArgument var1);

    public abstract String[] asStringArray(BaseArgument ... var1);
}

