/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command.range;

import com.syntaxphoenix.syntaxapi.command.ArgumentRangeSerializer;
import com.syntaxphoenix.syntaxapi.command.BaseArgument;
import com.syntaxphoenix.syntaxapi.command.BaseArgumentRange;
import com.syntaxphoenix.syntaxapi.command.RangeType;
import java.util.Arrays;
import java.util.List;

public class TextChooseRange
extends BaseArgumentRange {
    private final boolean blacklist;
    private final List<CharSequence> values;

    public TextChooseRange(CharSequence ... values) {
        this(false, values);
    }

    public TextChooseRange(boolean blacklist, CharSequence ... values) {
        this(blacklist, Arrays.asList(values));
    }

    public TextChooseRange(List<CharSequence> values) {
        this(false, values);
    }

    public TextChooseRange(boolean blacklist, List<CharSequence> values) {
        this.blacklist = blacklist;
        this.values = values;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public List<CharSequence> getValues() {
        return this.values;
    }

    @Override
    public RangeType getType() {
        return RangeType.TEXT_CHOOSE_RANGE;
    }

    @Override
    public Class<?> getInputType() {
        return this.getType().getInputType();
    }

    @Override
    public boolean hasType(BaseArgument argument) {
        return argument.getClassType().isAssignableFrom(this.getInputType());
    }

    @Override
    public boolean isInRange(BaseArgument argument) {
        if (!this.hasType(argument)) {
            return false;
        }
        return this.values.contains(argument.asObject());
    }

    @Override
    public String toString() {
        return this.toString(ArgumentRangeSerializer.DEFAULT);
    }

    @Override
    public String toString(ArgumentRangeSerializer serializer) {
        return serializer.toString(this);
    }
}

