/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.ArgumentIdentifier;
import com.syntaxphoenix.syntaxapi.command.Arguments;
import com.syntaxphoenix.syntaxapi.command.BaseCommand;
import com.syntaxphoenix.syntaxapi.command.BaseInfo;
import com.syntaxphoenix.syntaxapi.command.CommandProcess;
import com.syntaxphoenix.syntaxapi.command.DefaultInfo;
import com.syntaxphoenix.syntaxapi.command.ExecutionState;
import com.syntaxphoenix.syntaxapi.logging.ILogger;
import com.syntaxphoenix.syntaxapi.utils.alias.Alias;
import com.syntaxphoenix.syntaxapi.utils.alias.AliasMap;
import com.syntaxphoenix.syntaxapi.utils.java.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public class CommandManager {
    protected BiFunction<CommandManager, String, ? extends BaseInfo> infoConstructor = (manager, label) -> new DefaultInfo((CommandManager)manager, (String)label);
    protected final AliasMap<BaseCommand> commands = new AliasMap();
    protected ArgumentIdentifier validator = ArgumentIdentifier.DEFAULT;
    protected ILogger logger = null;
    protected String splitter = " ";
    protected String prefix = "!";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AliasMap<BaseCommand> getClonedMap() {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            return this.commands.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Alias, BaseCommand>[] getEntries() {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            return this.commands.entrySet().toArray(new Map.Entry[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseCommand[] getCommands() {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            return this.commands.values().toArray(new BaseCommand[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alias[] getAliases() {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            return this.commands.keySet().toArray(new Alias[0]);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public BiFunction<CommandManager, String, ? extends BaseInfo> getInfoConstructor() {
        return this.infoConstructor;
    }

    public ArgumentIdentifier getValidator() {
        return this.validator;
    }

    public boolean hasLogger() {
        return this.logger != null;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public CommandManager setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public CommandManager setSplitter(String splitter) {
        this.splitter = splitter;
        return this;
    }

    public CommandManager setInfoConstructor(BiFunction<CommandManager, String, ? extends BaseInfo> infoConstructor) {
        this.infoConstructor = infoConstructor;
        return this;
    }

    public CommandManager setValidator(ArgumentIdentifier validator) {
        this.validator = validator;
        return this;
    }

    public CommandManager setLogger(ILogger logger) {
        this.logger = logger;
        return this;
    }

    public CommandManager register(BaseCommand command, String name, String ... aliases) {
        return this.register(command, new Alias(name, aliases));
    }

    public CommandManager register(BaseCommand command, String description, String name, String[] aliases) {
        return this.register(command, new Alias(name, aliases).setDescription(description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandManager register(BaseCommand command, Alias alias) {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            if (this.commands.hasConflict(alias).isEmpty()) {
                this.commands.put(alias, (Object)command);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandManager unregister(BaseCommand command) {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            if (!this.commands.containsValue((Object)command)) {
                return this;
            }
            Optional<Map.Entry> optional = this.commands.entrySet().stream().filter(entry -> ((BaseCommand)entry.getValue()).equals(command)).findFirst();
            if (optional.isPresent()) {
                this.commands.remove(optional.get().getKey());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandManager unregister(String name) {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            if (this.commands.hasConflict(new Alias(name, new String[0])).isEmpty()) {
                return this;
            }
            Optional<Alias> optional = this.commands.keySet().stream().filter(alias -> alias.isLabel(name)).findFirst();
            if (optional.isPresent()) {
                this.commands.remove((Object)optional.get());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandManager unregister(Alias alias) {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            String[] conflicts = this.commands.hasConflict(alias).toArray(new String[0]);
            if (conflicts.length == 0) {
                return this;
            }
            Alias[] aliases = (Alias[])this.commands.keySet().stream().filter(current -> this.hasLabel(conflicts, (Alias)current)).toArray(Alias[]::new);
            for (int index = 0; index < aliases.length; ++index) {
                this.commands.remove((Object)aliases[index]);
            }
        }
        return this;
    }

    private boolean hasLabel(String[] source, Alias compare) {
        for (int index = 0; index < source.length; ++index) {
            if (!compare.isLabel(source[index])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandManager unregisterAll() {
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            this.commands.clear();
        }
        return this;
    }

    public CommandProcess process(String message) {
        CommandProcess process = new CommandProcess(this);
        if (!message.startsWith(this.prefix) || message.equals(this.prefix)) {
            return process.lock();
        }
        return this.process(message.replace(this.prefix, "").split(this.splitter));
    }

    public CommandProcess process(String ... message) {
        return this.process(new CommandProcess(this), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandProcess process(CommandProcess process, String ... message) {
        String command = message[0].toLowerCase();
        process.setLabel(command);
        if (command.isEmpty()) {
            return process.lock();
        }
        process.setValid(true);
        AliasMap<BaseCommand> aliasMap = this.commands;
        synchronized (aliasMap) {
            if (!this.commands.containsKey(command)) {
                return process.lock();
            }
            process.setCommand((BaseCommand)this.commands.get(command));
        }
        process.setArguments(new Arguments(this.validator.process((String[])Arrays.subArray(String[]::new, (Object[])message, (int)1))));
        return process.lock();
    }

    public ExecutionState execute(String message) {
        return this.process(message).execute();
    }

    public ExecutionState execute(CommandProcess process) {
        ExecutionState state = process.asState();
        if (!state.isRunnable()) {
            return state;
        }
        return this.execute(process.getCommand(), process.constructInfo(), process.getArguments());
    }

    public ExecutionState execute(BaseCommand command, BaseInfo info, Arguments arguments) {
        try {
            command.execute(info, arguments);
        }
        catch (Throwable throwable) {
            if (this.hasLogger()) {
                this.logger.log(throwable);
            }
            return ExecutionState.FAILED;
        }
        return ExecutionState.SUCCESS;
    }
}

