/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.data.container.nbt;

import com.syntaxphoenix.syntaxapi.data.DataAdapter;
import com.syntaxphoenix.syntaxapi.data.DataContainer;
import com.syntaxphoenix.syntaxapi.nbt.NbtBigDecimal;
import com.syntaxphoenix.syntaxapi.nbt.NbtBigInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtByte;
import com.syntaxphoenix.syntaxapi.nbt.NbtByteArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtDouble;
import com.syntaxphoenix.syntaxapi.nbt.NbtFloat;
import com.syntaxphoenix.syntaxapi.nbt.NbtInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtIntArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtLong;
import com.syntaxphoenix.syntaxapi.nbt.NbtLongArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtShort;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import com.syntaxphoenix.syntaxapi.utils.java.Primitives;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;

public class NbtAdapter<P, C extends NbtTag>
extends DataAdapter<P, C, NbtTag> {
    protected NbtAdapter(Class<P> primitiveType, Class<C> resultType, Function<P, C> builder, Function<C, P> extractor) {
        super(primitiveType, resultType, builder, extractor);
    }

    public Class<NbtTag> getBaseType() {
        return NbtTag.class;
    }

    protected static DataAdapter<?, ?, NbtTag> createAdapter(Class<?> type) {
        if (Objects.equals(Byte.class, type = Primitives.fromPrimitive(type))) {
            return new NbtAdapter<Byte, NbtByte>(Byte.class, NbtByte.class, NbtByte::new, value -> value.getByteValue());
        }
        if (Objects.equals(Short.class, type)) {
            return new NbtAdapter<Short, NbtShort>(Short.class, NbtShort.class, NbtShort::new, value -> value.getShortValue());
        }
        if (Objects.equals(Integer.class, type)) {
            return new NbtAdapter<Integer, NbtInt>(Integer.class, NbtInt.class, NbtInt::new, value -> value.getIntValue());
        }
        if (Objects.equals(Long.class, type)) {
            return new NbtAdapter<Long, NbtLong>(Long.class, NbtLong.class, NbtLong::new, value -> value.getLongValue());
        }
        if (Objects.equals(BigInteger.class, type)) {
            return new NbtAdapter<BigInteger, NbtBigInt>(BigInteger.class, NbtBigInt.class, NbtBigInt::new, value -> value.getInteger());
        }
        if (Objects.equals(Float.class, type)) {
            return new NbtAdapter<Float, NbtFloat>(Float.class, NbtFloat.class, NbtFloat::new, value -> Float.valueOf(value.getFloatValue()));
        }
        if (Objects.equals(Double.class, type)) {
            return new NbtAdapter<Double, NbtDouble>(Double.class, NbtDouble.class, NbtDouble::new, value -> value.getDoubleValue());
        }
        if (Objects.equals(BigDecimal.class, type)) {
            return new NbtAdapter<BigDecimal, NbtBigDecimal>(BigDecimal.class, NbtBigDecimal.class, NbtBigDecimal::new, value -> value.getDecimal());
        }
        if (Objects.equals(String.class, type)) {
            return new NbtAdapter<String, NbtString>(String.class, NbtString.class, NbtString::new, value -> value.getValue());
        }
        if (Objects.equals(byte[].class, type)) {
            return new NbtAdapter<byte[], NbtByteArray>(byte[].class, NbtByteArray.class, NbtByteArray::new, value -> value.getValue());
        }
        if (Objects.equals(int[].class, type)) {
            return new NbtAdapter<int[], NbtIntArray>(int[].class, NbtIntArray.class, NbtIntArray::new, value -> value.getValue());
        }
        if (Objects.equals(long[].class, type)) {
            return new NbtAdapter<long[], NbtLongArray>(long[].class, NbtLongArray.class, NbtLongArray::new, value -> value.getValue());
        }
        if (Objects.equals(DataContainer[].class, type)) {
            return new NbtAdapter<DataContainer[], NbtList>(DataContainer[].class, NbtList.class, containers -> {
                NbtList list = new NbtList(NbtType.COMPOUND);
                return list;
            }, list -> null);
        }
        if (Objects.equals(DataContainer.class, type)) {
            return new NbtAdapter<DataContainer, NbtCompound>(DataContainer.class, NbtCompound.class, container -> null, compound -> null);
        }
        if (Objects.equals(NbtTag.class, type)) {
            return new NbtAdapter<NbtTag, NbtTag>(NbtTag.class, NbtTag.class, tag -> tag, tag -> tag);
        }
        return null;
    }
}

