/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.data.container.nbt;

import com.syntaxphoenix.syntaxapi.data.DataAdapterContext;
import com.syntaxphoenix.syntaxapi.data.DataContainer;
import com.syntaxphoenix.syntaxapi.data.DataType;
import com.syntaxphoenix.syntaxapi.data.container.nbt.NbtAdapterRegistry;
import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.utils.NbtStorage;
import com.syntaxphoenix.syntaxapi.utils.java.Primitives;
import java.util.Set;

public class NbtContainer
extends DataContainer
implements DataAdapterContext,
NbtStorage<NbtCompound> {
    private final NbtCompound root = new NbtCompound();
    private final NbtAdapterRegistry registry;

    public NbtContainer(NbtAdapterRegistry registry) {
        this.registry = registry;
    }

    public NbtContainer newDataContainer() {
        return new NbtContainer(this.registry);
    }

    public DataAdapterContext getAdapterContext() {
        return this;
    }

    public NbtAdapterRegistry getAdapterRegistry() {
        return this.registry;
    }

    public NbtCompound getRoot() {
        return this.root;
    }

    public Object get(String key) {
        NbtTag tag = this.root.get(key);
        if (tag == null) {
            return tag;
        }
        return this.registry.extract(tag);
    }

    public void set(String key, NbtTag tag) {
        this.root.set(key, tag);
    }

    public void set(String key, Object primitive) {
        if (!Primitives.isInstance((Object)primitive)) {
            return;
        }
        this.root.set(key, (NbtTag)this.registry.wrap(Primitives.fromPrimitive(primitive.getClass()), primitive));
    }

    public <E, V> void set(String key, E value, DataType<V, E> type) {
        this.root.set(key, (NbtTag)this.registry.wrap(type.getPrimitive(), type.toPrimitive(this.getAdapterContext(), value)));
    }

    public boolean remove(String key) {
        return this.root.remove(key) != null;
    }

    public Set<String> getKeys() {
        return this.root.getKeys();
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public int size() {
        return this.root.size();
    }

    public void fromNbt(NbtCompound nbt) {
        this.root.clear();
        for (String key : nbt.getKeys()) {
            this.root.set(key, nbt.get(key));
        }
    }

    public NbtCompound asNbt() {
        return this.root.clone();
    }
}

