/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.data.property;

import com.syntaxphoenix.syntaxapi.data.property.Property;
import java.util.ArrayList;
import java.util.Optional;

public abstract class AbstractProperties {
    private final ArrayList<Property<?>> properties = new ArrayList();

    public void setProperties(Property<?> ... properties) {
        this.clearProperties();
        for (Property<?> property : properties) {
            this.setProperty(property);
        }
    }

    public void setProperty(Property<?> property) {
        Property<?> remove = this.findProperty(property.getKey());
        if (remove != null) {
            this.properties.remove(remove);
        }
        this.properties.add(property);
    }

    public void addProperties(Property<?> ... properties) {
        for (Property<?> property : properties) {
            this.addProperty(property);
        }
    }

    public void addProperty(Property<?> property) {
        if (!this.containsProperty(property.getKey())) {
            this.properties.add(property);
        }
    }

    public void removeProperties(String ... keys) {
        for (String key : keys) {
            this.removeProperty(key);
        }
    }

    public boolean removeProperty(String key) {
        if (this.properties.isEmpty()) {
            return false;
        }
        Optional<Property> optional = this.properties.stream().filter(property -> property.getKey().equals(key)).findFirst();
        if (optional.isPresent()) {
            return this.properties.remove(optional.get());
        }
        return false;
    }

    public Property<?> findProperty(String key) {
        if (this.properties.isEmpty()) {
            return null;
        }
        Optional<Property> optional = this.properties.stream().filter(property -> property.getKey().equals(key)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public ArrayList<Property<?>> findProperties(String ... keys) {
        ArrayList properties = new ArrayList();
        for (String key : keys) {
            Property<?> property = this.findProperty(key);
            if (property == null) continue;
            properties.add(property);
        }
        return properties;
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public boolean containsProperty(String key) {
        return this.properties.stream().anyMatch(property -> property.getKey().equals(key));
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public Property<?>[] getProperties() {
        return this.properties.toArray(new Property[0]);
    }
}

