/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.data.property;

import java.io.Serializable;
import java.util.HashMap;

public class Property<E>
implements Serializable {
    private static final long serialVersionUID = 8586167622486650403L;
    private static final transient HashMap<Class<?>, Class<?>> PRIMITIVE_OBJECT_TYPES = new HashMap();
    private String key;
    private E value;

    public Property(String key, E value) {
        this.key = key;
        this.value = value;
    }

    public <Z> Property<Z> tryParse(Class<Z> clz) {
        Class<?> clazz;
        if (this.instanceOf(clz)) {
            return this;
        }
        if (PRIMITIVE_OBJECT_TYPES.containsKey(clz) && this.instanceOf(clazz = PRIMITIVE_OBJECT_TYPES.get(clz))) {
            return this;
        }
        return null;
    }

    public Property<String> parseString() {
        Property<String> output = this.tryParse(String.class);
        if (output == null) {
            output = new Property<String>(this.key, this.value.toString());
        }
        return output;
    }

    public <Z> boolean instanceOf(Class<Z> clz) {
        return clz.isInstance(this.value);
    }

    public boolean isSerializable() {
        return this.value.getClass().isAssignableFrom(Serializable.class);
    }

    public String getHolderKey() {
        return "%" + this.key + "%";
    }

    public String getKey() {
        return this.key;
    }

    public Class<E> getValueOwner() {
        return this.value.getClass();
    }

    public E getValue() {
        return this.value;
    }

    public static Property<Object> createObject(String key, Object value) {
        return new Property<Object>(key, value);
    }

    public static <T> Property<T> create(String key, T value) {
        return new Property<T>(key, value);
    }

    static {
        PRIMITIVE_OBJECT_TYPES.put(Byte.TYPE, Byte.class);
        PRIMITIVE_OBJECT_TYPES.put(Short.TYPE, Short.class);
        PRIMITIVE_OBJECT_TYPES.put(Integer.TYPE, Integer.class);
        PRIMITIVE_OBJECT_TYPES.put(Long.TYPE, Long.class);
        PRIMITIVE_OBJECT_TYPES.put(Float.TYPE, Float.class);
        PRIMITIVE_OBJECT_TYPES.put(Double.TYPE, Double.class);
        PRIMITIVE_OBJECT_TYPES.put(Boolean.TYPE, Boolean.class);
    }
}

