/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.event;

import com.syntaxphoenix.syntaxapi.event.Event;
import com.syntaxphoenix.syntaxapi.event.EventExecutor;
import com.syntaxphoenix.syntaxapi.event.EventHandler;
import com.syntaxphoenix.syntaxapi.event.EventListener;
import com.syntaxphoenix.syntaxapi.event.EventManager;
import com.syntaxphoenix.syntaxapi.event.EventMethod;
import com.syntaxphoenix.syntaxapi.reflection.AbstractReflect;
import com.syntaxphoenix.syntaxapi.reflection.Reflect;
import java.lang.reflect.Method;
import java.util.HashMap;

public final class EventAnalyser {
    private final EventListener listener;
    private final AbstractReflect reflect;

    public EventAnalyser(EventListener listener) {
        this.listener = listener;
        this.reflect = new Reflect(listener.getClass()).searchMethodsByArguments("event", new Class[]{Event.class});
    }

    public AbstractReflect getReflect() {
        return this.reflect;
    }

    public EventListener getListener() {
        return this.listener;
    }

    protected int registerEvents(EventManager manager) {
        String name;
        String base = "event-";
        int current = 0;
        HashMap executors = new HashMap();
        while (this.reflect.containsMethod(name = base + current)) {
            EventHandler handler;
            ++current;
            Method method = this.reflect.getMethod(name);
            try {
                handler = method.getAnnotation(EventHandler.class);
            }
            catch (NullPointerException e) {
                manager.getLogger().log((Throwable)e);
                continue;
            }
            Class<?> clazz = method.getParameterTypes()[0];
            if (executors.containsKey(clazz)) {
                ((EventExecutor)executors.get(clazz)).add(handler.priority(), new EventMethod(this.listener, method, handler.ignoreCancel()));
                continue;
            }
            executors.put(clazz, new EventExecutor(manager, this.listener, clazz).add(handler.priority(), new EventMethod(this.listener, method, handler.ignoreCancel())));
        }
        manager.registerExecutors(executors.values());
        return current;
    }
}

