/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.event;

import com.syntaxphoenix.syntaxapi.event.Cancelable;
import com.syntaxphoenix.syntaxapi.event.Event;
import com.syntaxphoenix.syntaxapi.event.EventExecutor;
import com.syntaxphoenix.syntaxapi.event.EventManager;
import com.syntaxphoenix.syntaxapi.event.EventMethod;
import com.syntaxphoenix.syntaxapi.event.EventPriority;
import com.syntaxphoenix.syntaxapi.utils.general.Status;
import com.syntaxphoenix.syntaxapi.utils.java.Exceptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class EventCall {
    private final List<EventExecutor> executors;
    private final EventManager manager;
    private final Event event;

    public EventCall(EventManager manager, Event event, List<EventExecutor> executors) {
        this.executors = executors;
        this.manager = manager;
        this.event = event;
        Collections.sort(executors);
    }

    public final EventManager getManager() {
        return this.manager;
    }

    public final Event getEvent() {
        return this.event;
    }

    public final List<EventExecutor> getExecutors() {
        return this.executors;
    }

    public Status execute() {
        int count = 0;
        if (this.executors.isEmpty()) {
            return new Status(count);
        }
        LinkedHashMap<EventPriority, ArrayList<EventMethod>> listeners = new LinkedHashMap<EventPriority, ArrayList<EventMethod>>();
        for (EventPriority priority : EventPriority.values()) {
            ArrayList<EventMethod> methods = new ArrayList<EventMethod>();
            for (EventExecutor executor : this.executors) {
                methods.addAll(executor.getMethodsByPriority(priority));
            }
            count += methods.size();
            listeners.put(priority, methods);
        }
        Status result = new Status(count);
        return this.event instanceof Cancelable ? this.callCancelable(result, listeners) : this.call(result, listeners);
    }

    public Status executeAsync(ExecutorService service) {
        int count = 0;
        if (this.executors.isEmpty()) {
            return new Status(count);
        }
        LinkedHashMap listeners = new LinkedHashMap();
        for (EventPriority priority : EventPriority.values()) {
            ArrayList<EventMethod> methods = new ArrayList<EventMethod>();
            for (EventExecutor executor : this.executors) {
                methods.addAll(executor.getMethodsByPriority(priority));
            }
            count += methods.size();
            listeners.put(priority, methods);
        }
        Status result = new Status(count);
        service.submit(() -> {
            if (this.event instanceof Cancelable) {
                this.callCancelable(result, listeners);
            } else {
                this.call(result, listeners);
            }
        });
        return result;
    }

    private Status callCancelable(Status result, LinkedHashMap<EventPriority, ArrayList<EventMethod>> listeners) {
        Cancelable cancel = (Cancelable)((Object)this.event);
        for (EventPriority priority : EventPriority.ORDERED_VALUES) {
            ArrayList<EventMethod> methods = listeners.get((Object)priority);
            if (methods.isEmpty()) continue;
            for (EventMethod method : methods) {
                if (cancel.isCancelled() && !method.ignoresCancel()) {
                    result.cancel();
                    continue;
                }
                try {
                    method.execute(this.event);
                    result.success();
                }
                catch (Throwable throwable) {
                    result.failed();
                    if (this.manager.hasLogger()) {
                        this.manager.getLogger().log(throwable);
                        continue;
                    }
                    System.out.println(Exceptions.stackTraceToString((Throwable)throwable));
                }
            }
        }
        result.done();
        return result;
    }

    private Status call(Status result, LinkedHashMap<EventPriority, ArrayList<EventMethod>> listeners) {
        for (EventPriority priority : EventPriority.ORDERED_VALUES) {
            ArrayList<EventMethod> methods = listeners.get((Object)priority);
            if (methods.isEmpty()) continue;
            for (EventMethod method : methods) {
                try {
                    method.execute(this.event);
                    result.success();
                }
                catch (Throwable throwable) {
                    result.failed();
                    if (this.manager.hasLogger()) {
                        this.manager.getLogger().log(throwable);
                        continue;
                    }
                    System.out.println(Exceptions.stackTraceToString((Throwable)throwable));
                }
            }
        }
        result.done();
        return result;
    }
}

