/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.event;

import com.syntaxphoenix.syntaxapi.event.Event;
import com.syntaxphoenix.syntaxapi.event.EventListener;
import com.syntaxphoenix.syntaxapi.event.EventManager;
import com.syntaxphoenix.syntaxapi.event.EventMethod;
import com.syntaxphoenix.syntaxapi.event.EventPriority;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public final class EventExecutor
implements Comparable<EventExecutor> {
    private final EnumMap<EventPriority, ArrayList<EventMethod>> methods = new EnumMap(EventPriority.class);
    private final Class<? extends Event> event;
    private final EventListener listener;
    private final EventManager manager;

    public EventExecutor(EventManager manager, EventListener listener, Class<? extends Event> event) {
        this.listener = listener;
        this.manager = manager;
        this.event = event;
    }

    public final EventManager getManager() {
        return this.manager;
    }

    public final EventListener getListener() {
        return this.listener;
    }

    public final Class<? extends Event> getEvent() {
        return this.event;
    }

    protected EventExecutor add(EventPriority priority, EventMethod method) {
        ArrayList<EventMethod> list = this.methods.get((Object)priority);
        if (list == null) {
            list = new ArrayList();
            this.methods.put(priority, list);
        } else if (list.contains(method)) {
            return this;
        }
        list.add(method);
        return this;
    }

    public List<EventMethod> getMethodsByPriority(EventPriority priority) {
        if (!this.methods.containsKey((Object)priority)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList((List)this.methods.get((Object)priority));
    }

    public List<EventMethod> getMethods() {
        ArrayList<EventMethod> output = new ArrayList<EventMethod>();
        this.methods.forEach((priority, list) -> output.addAll((Collection<EventMethod>)list));
        return output;
    }

    @Override
    public int compareTo(EventExecutor o) {
        Class<? extends Event> other = o.getEvent();
        if (this.event.equals(other)) {
            return 0;
        }
        if (this.event.isAssignableFrom(other)) {
            return -1;
        }
        return 1;
    }
}

