/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.event;

import com.syntaxphoenix.syntaxapi.event.Event;
import com.syntaxphoenix.syntaxapi.event.EventAnalyser;
import com.syntaxphoenix.syntaxapi.event.EventCall;
import com.syntaxphoenix.syntaxapi.event.EventExecutor;
import com.syntaxphoenix.syntaxapi.event.EventListener;
import com.syntaxphoenix.syntaxapi.event.EventMethod;
import com.syntaxphoenix.syntaxapi.event.EventPriority;
import com.syntaxphoenix.syntaxapi.logging.ILogger;
import com.syntaxphoenix.syntaxapi.utils.general.Status;
import com.syntaxphoenix.syntaxapi.utils.java.Collect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class EventManager {
    private final LinkedHashMap<Class<? extends Event>, ArrayList<EventExecutor>> listeners = new LinkedHashMap();
    private final ILogger logger;
    private final ExecutorService service;

    public EventManager() {
        this(null, null);
    }

    public EventManager(ExecutorService service) {
        this(null, service);
    }

    public EventManager(ILogger logger) {
        this(logger, null);
    }

    public EventManager(ILogger logger, ExecutorService service) {
        this.logger = logger;
        this.service = service;
    }

    public boolean hasLogger() {
        return this.logger != null;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public boolean isAsync() {
        return this.service != null;
    }

    public ExecutorService getExecutorService() {
        return this.service;
    }

    public EventCall generateCall(Event event) {
        return new EventCall(this, event, this.getExecutorsForEvent(event.getClass(), true));
    }

    public Status call(Event event) {
        return this.call(this.generateCall(event));
    }

    public Status call(EventCall call) {
        if (this.isAsync()) {
            return call.executeAsync(this.service);
        }
        return call.execute();
    }

    public Status callAsync(Event event, ExecutorService service) {
        return this.callAsync(this.generateCall(event), service);
    }

    public Status callAsync(EventCall call, ExecutorService service) {
        return call.executeAsync(service);
    }

    public EventManager registerEvents(EventListener listener) {
        EventAnalyser analyser = new EventAnalyser(listener);
        analyser.registerEvents(this);
        return this;
    }

    public EventManager registerEvent(EventMethod method) {
        if (!method.isValid()) {
            return this;
        }
        EventExecutor executor = new EventExecutor(this, method.getListener(), method.getEvent());
        executor.add(method.hasEventHandler() ? method.getHandler().priority() : EventPriority.NORMAL, method);
        this.registerExecutor(executor);
        return this;
    }

    public EventManager registerExecutors(Collection<EventExecutor> executors) {
        executors.forEach(executor -> this.registerExecutor((EventExecutor)executor));
        return this;
    }

    public EventManager registerExecutor(EventExecutor executor) {
        if (executor == null || executor.getMethods().isEmpty()) {
            return this;
        }
        Class<? extends Event> event = executor.getEvent();
        if (this.listeners.containsKey(event)) {
            ArrayList<EventExecutor> executors = this.listeners.get(event);
            if (!executors.contains(executor)) {
                executors.add(executor);
            }
        } else if (!this.listeners.containsKey(event)) {
            ArrayList<EventExecutor> executors = new ArrayList<EventExecutor>();
            executors.add(executor);
            this.listeners.put(event, executors);
        }
        return this;
    }

    public EventManager unregisterEvent(Class<? extends Event> event) {
        this.listeners.remove(event);
        return this;
    }

    public EventManager unregisterEvents(Class<? extends EventListener> listener) {
        return this.unregisterExecutors(this.getExecutorsFromOwner(listener));
    }

    public EventManager unregisterEvents(EventListener listener) {
        return this.unregisterExecutors(this.getExecutorsFromOwner(listener));
    }

    public EventManager unregisterExecutors(Iterable<EventExecutor> executors) {
        return this.unregisterExecutors(executors.iterator());
    }

    public EventManager unregisterExecutors(Iterator<EventExecutor> executors) {
        while (executors.hasNext()) {
            this.unregisterExecutor(executors.next());
        }
        return this;
    }

    public EventManager unregisterExecutors(EventExecutor ... executors) {
        for (EventExecutor executor : executors) {
            this.unregisterExecutor(executor);
        }
        return this;
    }

    public EventManager unregisterExecutor(EventExecutor executor) {
        ArrayList<EventExecutor> list = this.listeners.get(executor.getEvent());
        if (list != null && list.contains(executor)) {
            list.remove(executor);
        }
        return this;
    }

    public List<? extends EventListener> getOwners() {
        return (List)this.getExecutors().stream().collect(Collect.collectList((output, input) -> {
            if (!output.contains(input.getListener())) {
                output.add(input.getListener());
            }
        }));
    }

    public List<Class<? extends EventListener>> getOwnerClasses() {
        return (List)this.getOwners().stream().collect(Collect.collectList((output, input) -> output.add(input.getClass())));
    }

    public List<Class<? extends Event>> getEvents() {
        return this.listeners.keySet().stream().collect(Collectors.toList());
    }

    public List<EventExecutor> getExecutors() {
        return (List)this.listeners.values().stream().collect(Collect.combineList());
    }

    public List<EventExecutor> getExecutorsFromOwner(EventListener listener) {
        return this.getExecutors().stream().filter(executor -> executor.getListener() == listener).collect(Collectors.toList());
    }

    public List<EventExecutor> getExecutorsFromOwner(Class<? extends EventListener> listener) {
        return this.getExecutors().stream().filter(executor -> executor.getListener().getClass() == listener).collect(Collectors.toList());
    }

    public List<EventExecutor> getExecutorsForEvent(Class<? extends Event> event) {
        return this.getExecutorsForEvent(event, false);
    }

    public List<EventExecutor> getExecutorsForEvent(Class<? extends Event> event, boolean allowAssignableClasses) {
        if (!allowAssignableClasses) {
            if (!this.listeners.containsKey(event)) {
                return new ArrayList<EventExecutor>();
            }
            return (List)this.listeners.get(event).clone();
        }
        ArrayList executors = new ArrayList();
        Set<Class<? extends Event>> keys = this.listeners.keySet();
        for (Class<? extends Event> assign : keys) {
            if (!assign.isAssignableFrom(event)) continue;
            executors.addAll(this.listeners.get(assign));
        }
        return (List)executors.clone();
    }
}

