/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.event;

import com.syntaxphoenix.syntaxapi.event.Event;
import com.syntaxphoenix.syntaxapi.event.EventHandler;
import com.syntaxphoenix.syntaxapi.event.EventListener;
import com.syntaxphoenix.syntaxapi.reflection.ReflectionTools;
import java.lang.reflect.Method;

public class EventMethod {
    private final EventListener listener;
    private final boolean ignoreCancel;
    private final Method method;

    public EventMethod(EventListener listener, Method method) {
        this.listener = listener;
        this.method = method;
        this.ignoreCancel = this.hasEventHandler() ? this.getHandler().ignoreCancel() : false;
    }

    public EventMethod(EventListener listener, Method method, boolean ignoreCancel) {
        this.listener = listener;
        this.method = method;
        this.ignoreCancel = ignoreCancel;
    }

    public boolean isValid() {
        return ReflectionTools.hasSameArguments((Class[])new Class[]{Event.class}, (Class[])this.method.getParameterTypes());
    }

    public final boolean hasEventHandler() {
        return this.getHandler() != null;
    }

    public final Class<? extends Event> getEvent() {
        return this.method.getParameterTypes()[0];
    }

    public final EventHandler getHandler() {
        return this.method.getAnnotation(EventHandler.class);
    }

    public final boolean ignoresCancel() {
        return this.ignoreCancel;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final EventListener getListener() {
        return this.listener;
    }

    public void execute(Event event) {
        ReflectionTools.execute((Object)this.listener, (Method)this.method, (Object[])new Object[]{event});
    }
}

