/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.general;

public class Status {
    public static final Status EMPTY = new Status(true);
    private int total = 0;
    private int failed = 0;
    private int success = 0;
    private int skipped = 0;
    private int cancelled = 0;
    private int marked = 0;
    private boolean done = false;

    public static final Status create() {
        return new Status(false);
    }

    private Status(boolean done) {
        this.done = done;
    }

    public Status(int total) {
        this.total = total;
    }

    public void done() {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean success() {
        if (this.done || !this.mark()) {
            return false;
        }
        ++this.success;
        return true;
    }

    public boolean failed() {
        if (this.done || !this.mark()) {
            return false;
        }
        ++this.failed;
        return true;
    }

    public boolean skip() {
        if (this.done || !this.mark()) {
            return false;
        }
        ++this.skipped;
        return true;
    }

    public boolean cancel() {
        if (this.done || !this.mark()) {
            return false;
        }
        ++this.cancelled;
        return true;
    }

    private boolean mark() {
        if (this.marked == this.total) {
            return false;
        }
        ++this.marked;
        return true;
    }

    public void add() {
        this.add(1);
    }

    public void add(int amount) {
        if (this.done) {
            return;
        }
        this.total += amount;
    }

    public void add(Status status) {
        if (this.done) {
            return;
        }
        this.total += status.total;
        this.failed += status.failed;
        this.marked += status.marked;
        this.success += status.success;
        this.skipped += status.skipped;
        this.cancelled += status.cancelled;
    }

    public int getTotal() {
        return this.total;
    }

    public int getMarked() {
        return this.marked;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSuccess() {
        return this.success;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getCancelled() {
        return this.cancelled;
    }
}

