/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.java;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_COMPLEX;
    private static final Map<Class<?>, Class<?>> COMPLEX_TO_PRIMITIVE;

    public static boolean isInstance(Object object) {
        return Primitives.isComplex(object) || Primitives.isPrimitive(object);
    }

    public static boolean isInstance(Class<?> type) {
        return Primitives.isComplex(type) || Primitives.isPrimitive(type);
    }

    public static boolean isComplex(Object object) {
        return object == null ? false : (object instanceof Class ? Primitives.isComplex((Class)object) : Primitives.isComplex(object.getClass()));
    }

    public static boolean isComplex(Class<?> type) {
        return COMPLEX_TO_PRIMITIVE.containsKey(type);
    }

    public static boolean isPrimitive(Object object) {
        return object == null ? false : (object instanceof Class ? Primitives.isPrimitive((Class)object) : Primitives.isPrimitive(object.getClass()));
    }

    public static boolean isPrimitive(Class<?> type) {
        return PRIMITIVE_TO_COMPLEX.containsKey(type);
    }

    public static <T> Class<T> fromPrimitive(Class<T> primitive) {
        Objects.requireNonNull(primitive);
        Class<?> complex = PRIMITIVE_TO_COMPLEX.get(primitive);
        return complex == null ? primitive : complex;
    }

    public static <T> Class<T> toPrimitive(Class<T> complex) {
        Objects.requireNonNull(complex);
        Class<?> primitive = COMPLEX_TO_PRIMITIVE.get(complex);
        return primitive == null ? complex : primitive;
    }

    static {
        LinkedHashMap collect = new LinkedHashMap(10);
        collect.put(Byte.TYPE, Byte.class);
        collect.put(Boolean.TYPE, Boolean.class);
        collect.put(Short.TYPE, Short.class);
        collect.put(Integer.TYPE, Integer.class);
        collect.put(Long.TYPE, Long.class);
        collect.put(Float.TYPE, Float.class);
        collect.put(Double.TYPE, Double.class);
        collect.put(String.class, String.class);
        collect.put(Void.TYPE, Void.class);
        collect.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_COMPLEX = Collections.unmodifiableMap(collect);
        collect = new LinkedHashMap(10);
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_TO_COMPLEX.entrySet()) {
            collect.put(entry.getValue(), entry.getKey());
        }
        COMPLEX_TO_PRIMITIVE = Collections.unmodifiableMap(collect);
    }
}

