/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.java.tools;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Container<T> {
    private static final Container<?> EMPTY = new Container();
    private boolean modifiable;
    private T value;

    public static <T> Container<T> empty() {
        return EMPTY;
    }

    private Container() {
        this.value = null;
        this.modifiable = false;
    }

    private Container(T value, boolean modifiable) {
        this.value = value;
        this.modifiable = modifiable;
    }

    public static <T> Container<T> of() {
        return new Container<Object>(null, true);
    }

    public static <T> Container<T> of(T value) {
        return new Container<T>(value, true);
    }

    public static <T> Container<T> ofUnmodifiable(T value) {
        return value == null ? Container.empty() : new Container<T>(value, false);
    }

    public static <T> Container<T> ofOptional(Optional<T> value) {
        return value.isPresent() ? new Container<Object>(null, true) : new Container<T>(value.get(), true);
    }

    public static <T> Container<T> ofOptionalUnmodifiable(Optional<T> value) {
        return value.isPresent() ? Container.empty() : new Container<T>(value.get(), false);
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public Container<T> replace(T value) {
        if (this.isModifiable()) {
            this.value = value;
        }
        return this;
    }

    public T get() {
        return this.value;
    }

    public Container<T> lock() {
        this.modifiable = false;
        return this;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.isEmpty()) {
            return;
        }
        action.accept(this.value);
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isEmpty()) {
            emptyAction.run();
            return;
        }
        action.accept(this.value);
    }

    public Container<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.isPresent() ? (predicate.test(this.value) ? this : Container.empty()) : this;
    }

    public <U> Container<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? Container.of(mapper.apply(this.value)) : Container.empty();
    }

    public <U> Container<U> flatMap(Function<? super T, ? extends Container<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? Objects.requireNonNull(mapper.apply(this.value)) : Container.empty();
    }

    public Container<T> or(Supplier<? extends Container<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        return this.isPresent() ? this : Objects.requireNonNull(supplier.get());
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.value) : Stream.empty();
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.value : supplier.get();
    }

    public T orElseThrow() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.isPresent() ? String.format("Container[%s]", this.value) : "Container.empty";
    }
}

