/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.key;

import com.syntaxphoenix.syntaxapi.utils.key.AbstractNamespace;
import com.syntaxphoenix.syntaxapi.utils.key.NamespacedKey;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class Namespace
extends AbstractNamespace<NamespacedKey> {
    private static final ConcurrentHashMap<String, Namespace> NAMESPACES = new ConcurrentHashMap();
    protected final String name;
    protected final ConcurrentHashMap<String, NamespacedKey> keys = new ConcurrentHashMap();

    public static Namespace of(String name) {
        if (NAMESPACES.containsKey(name)) {
            return NAMESPACES.get(name);
        }
        Namespace namespace = new Namespace(name);
        NAMESPACES.put(name, namespace);
        return namespace;
    }

    private Namespace(String name) {
        this.name = name;
        NAMESPACES.put(name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean contains(String key) {
        return this.keys.containsKey(key);
    }

    @Override
    public NamespacedKey createNamed(String key, String name) {
        return this.keys.computeIfAbsent(key, compute -> new NamespacedKey(this, (String)compute, name));
    }

    @Override
    public NamespacedKey create(String key) {
        return this.keys.computeIfAbsent(key, compute -> new NamespacedKey(this, (String)compute));
    }

    @Override
    public Optional<NamespacedKey> option(String key) {
        return Optional.ofNullable(this.keys.get(key));
    }

    @Override
    public NamespacedKey get(String key) {
        return this.keys.get(key);
    }

    @Override
    public String[] getKeyspaces() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.keys.keySet())).toArray(new String[0]);
    }

    public NamespacedKey[] getKeys() {
        return this.keys.values().toArray(new NamespacedKey[0]);
    }
}

