/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.logging;

import com.syntaxphoenix.syntaxapi.logging.ILogger;
import com.syntaxphoenix.syntaxapi.logging.LogTypeId;
import com.syntaxphoenix.syntaxapi.logging.LoggerState;
import com.syntaxphoenix.syntaxapi.logging.color.LogType;
import com.syntaxphoenix.syntaxapi.logging.color.LogTypeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class AsyncLogger
implements ILogger {
    private final ExecutorService executor;
    private final ILogger logger;

    public AsyncLogger(ILogger logger) {
        this(Executors.newSingleThreadExecutor(), logger);
    }

    public AsyncLogger(ExecutorService executor, ILogger logger) {
        this.executor = executor;
        this.logger = logger;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public AsyncLogger close() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(e);
        }
        this.logger.close();
        return this;
    }

    @Override
    public AsyncLogger setThreadName(String name) {
        this.logger.setThreadName(name);
        return this;
    }

    @Override
    public String getThreadName() {
        return this.logger.getThreadName();
    }

    @Override
    public AsyncLogger setState(LoggerState state) {
        this.logger.setState(state);
        return this;
    }

    @Override
    public LoggerState getState() {
        return this.logger.getState();
    }

    @Override
    public AsyncLogger setCustom(BiConsumer<Boolean, String> custom) {
        this.logger.setCustom(custom);
        return this;
    }

    @Override
    public BiConsumer<Boolean, String> getCustom() {
        return this.logger.getCustom();
    }

    @Override
    public AsyncLogger setType(LogType type) {
        this.logger.setType(type);
        return this;
    }

    @Override
    public LogType getType(String typeId) {
        return this.logger.getType(typeId);
    }

    @Override
    public ILogger setColored(boolean color) {
        this.logger.setColored(color);
        return this;
    }

    @Override
    public boolean isColored() {
        return this.logger.isColored();
    }

    @Override
    public LogTypeMap getTypeMap() {
        return this.logger.getTypeMap();
    }

    @Override
    public AsyncLogger log(String message) {
        this.queue(() -> this.logger.log(message));
        return this;
    }

    @Override
    public AsyncLogger log(LogTypeId type, String message) {
        this.queue(() -> this.logger.log(type, message));
        return this;
    }

    @Override
    public AsyncLogger log(String typeId, String message) {
        this.queue(() -> this.logger.log(typeId, message));
        return this;
    }

    @Override
    public AsyncLogger log(String ... messages) {
        this.queue(() -> this.logger.log(messages));
        return this;
    }

    @Override
    public AsyncLogger log(LogTypeId type, String ... messages) {
        this.queue(() -> this.logger.log(type, messages));
        return this;
    }

    @Override
    public AsyncLogger log(String typeId, String ... messages) {
        this.queue(() -> this.logger.log(typeId, messages));
        return this;
    }

    @Override
    public AsyncLogger log(Throwable throwable) {
        this.queue(() -> this.logger.log(throwable));
        return this;
    }

    @Override
    public AsyncLogger log(LogTypeId type, Throwable throwable) {
        this.queue(() -> this.logger.log(type, throwable));
        return this;
    }

    @Override
    public AsyncLogger log(String typeId, Throwable throwable) {
        this.queue(() -> this.logger.log(typeId, throwable));
        return this;
    }

    private void queue(Runnable runnable) {
        String name = Thread.currentThread().getName();
        this.executor.submit(() -> {
            this.logger.setThreadName(name);
            runnable.run();
        });
    }
}

