/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.logging;

public enum LoggerState {
    NONE,
    STREAM(false, true, false),
    EXTENDED_STREAM(true, true, false),
    CUSTOM(false, false, true),
    EXTENDED_CUSTOM(true, false, true),
    STREAM_CUSTOM(false, true, true),
    EXTENDED_STREAM_CUSTOM(true, true, true);

    private final boolean extended;
    private final boolean stream;
    private final boolean custom;
    private final boolean logging;

    private LoggerState(boolean extended, boolean stream, boolean custom) {
        this.extended = extended;
        this.stream = stream;
        this.custom = custom;
        this.logging = true;
    }

    private LoggerState() {
        this.extended = false;
        this.stream = false;
        this.custom = false;
        this.logging = false;
    }

    public boolean useCustom() {
        return this.custom;
    }

    public boolean useStream() {
        return this.stream;
    }

    public boolean extendedInfo() {
        return this.extended;
    }

    public boolean isEnabled() {
        return this.logging;
    }

    public static LoggerState byName(String name) {
        for (LoggerState state : LoggerState.values()) {
            if (!state.name().equalsIgnoreCase(name)) continue;
            return state;
        }
        return NONE;
    }

    public static LoggerState byOptions(boolean extended, boolean file, boolean console) {
        if (extended) {
            if (file) {
                if (console) {
                    return EXTENDED_STREAM_CUSTOM;
                }
                return EXTENDED_STREAM;
            }
            if (console) {
                return EXTENDED_CUSTOM;
            }
            return NONE;
        }
        if (file) {
            if (console) {
                return STREAM_CUSTOM;
            }
            return STREAM;
        }
        if (console) {
            return CUSTOM;
        }
        return NONE;
    }
}

