/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.logging.color;

import com.syntaxphoenix.syntaxapi.logging.color.LogType;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;

public class LogTypeMap {
    private final ArrayList<LogType> types = new ArrayList();

    public void register(LogType type) {
        if (this.contains(type)) {
            return;
        }
        this.types.add(type);
    }

    public void override(LogType type) {
        this.deleteById(type.getId());
        this.types.add(type);
    }

    public void delete(LogType type) {
        if (this.contains(type)) {
            this.types.remove(type);
        } else {
            this.deleteById(type.getId());
        }
    }

    public void deleteById(String id) {
        Optional<LogType> option = this.tryGetById(id);
        if (option.isPresent()) {
            this.delete(option.get());
        }
    }

    public LogType getById(String id) {
        return this.tryGetById(id).get();
    }

    public LogType getByName(String name) {
        return this.tryGetById(name).get();
    }

    public Optional<LogType> tryGetById(String id) {
        return this.tryGet(type -> type.getId().equals(id));
    }

    public Optional<LogType> tryGetByName(String name) {
        return this.tryGet(type -> type.getName().equals(name));
    }

    public Optional<LogType> tryGet(Predicate<LogType> predicate) {
        return this.types.stream().filter(predicate).findFirst();
    }

    public boolean contains(LogType type) {
        return type == null ? false : this.types.contains(type);
    }

    public boolean containsId(String id) {
        return this.tryGetById(id).isPresent();
    }

    public boolean containsName(String name) {
        return this.tryGetByName(name).isPresent();
    }
}

