/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.net.http.ContentType;
import com.syntaxphoenix.syntaxapi.net.http.HttpWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Answer {
    public static final Answer CONTINUE = new Answer(ContentType.JSON).code(100);
    public static final Answer NO_CONTENT = new Answer(ContentType.JSON).code(204);
    public static final Answer SERVER_ERROR = new Answer(ContentType.JSON).code(500);
    public static final List<String> BLOCKED = Arrays.asList("Content-Type", "Server", "Date", "Content-Length");
    private final HashMap<String, String> headers = new HashMap();
    private final ContentType type;
    private JsonObject object = new JsonObject();
    private int code = 404;

    public Answer(ContentType type) {
        this.type = type;
    }

    public String header(String key) {
        return this.headers.get(key);
    }

    public JsonElement respond(String key) {
        return this.object.get(key);
    }

    public ContentType type() {
        return this.type;
    }

    public int code() {
        return this.code;
    }

    public Answer code(int code) {
        this.code = code;
        return this;
    }

    public Answer header(String key, Object value) {
        return this.header(key, value.toString());
    }

    public Answer header(String key, String value) {
        if (value != null) {
            this.headers.put(key, value);
        } else {
            this.headers.remove(key);
        }
        return this;
    }

    public Answer respond(String key, String value) {
        if (value != null) {
            this.object.addProperty(key, value);
        } else {
            this.object.remove(key);
        }
        return this;
    }

    public Answer respond(String key, JsonElement element) {
        if (element != null) {
            this.object.add(key, element);
        } else {
            this.object.remove(key);
        }
        return this;
    }

    public Answer respond(JsonObject object) {
        this.object = object;
        return this;
    }

    public Answer clearHeaders() {
        this.headers.clear();
        return this;
    }

    public Answer clearResponse() {
        this.object = new JsonObject();
        return this;
    }

    public boolean hasResponse() {
        return !this.object.keySet().isEmpty();
    }

    public Answer write(HttpWriter writer) throws IOException {
        if (this.type == null) {
            return this;
        }
        byte[] data = null;
        int length = 0;
        if (this.object != null && this.hasResponse()) {
            data = this.type.serialize(this.object).getBytes(StandardCharsets.UTF_8);
            length = data.length;
        }
        writer.write(this.code).writeServer().writeDate().writeLength(length);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            if (BLOCKED.contains(header.getKey())) continue;
            writer.write(header);
        }
        if (this.type == ContentType.CUSTOM) {
            writer.writeType(this.headers.get("Content-Type"));
        } else {
            writer.writeType(this.type);
        }
        writer.line();
        if (data != null) {
            writer.write(data);
        }
        writer.clear();
        return this;
    }
}

