/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

@FunctionalInterface
public interface ContentSerializer {
    public static final ContentSerializer JSON = parameters -> parameters.toString();
    public static final ContentSerializer URL_ENCODED = parameters -> {
        if (parameters.entrySet().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("?");
        try {
            for (Map.Entry parameter : parameters.entrySet()) {
                builder.append(URLEncoder.encode((String)parameter.getKey(), "UTF-8"));
                builder.append('=');
                builder.append(URLEncoder.encode(((JsonElement)parameter.getValue()).getAsString(), "UTF-8"));
                builder.append('&');
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String value = builder.toString();
        return value.substring(0, value.length() - 1);
    };
    public static final ContentSerializer PLAIN = new ContentSerializer(){
        private final char[] CHARS = new char[]{':', ' ', '\t', '\n', '-'};
        private final String NULL = "null";
        private final String NEXT = "==>";

        @Override
        public String process(JsonObject parameters) {
            StringBuilder builder = new StringBuilder();
            this.append(builder, parameters, 0);
            return builder.toString();
        }

        private boolean append(StringBuilder builder, JsonObject object, int depth) {
            for (Map.Entry entry : object.entrySet()) {
                JsonElement element = (JsonElement)entry.getValue();
                for (int current = 0; current < depth; ++current) {
                    builder.append(this.CHARS[2]);
                }
                builder.append((String)entry.getKey());
                builder.append(this.CHARS[0]);
                builder.append(this.CHARS[1]);
                if (element == null || element.isJsonNull()) {
                    builder.append("null");
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    builder.append(element.getAsString());
                    continue;
                }
                builder.append(this.CHARS[3]);
                if (element.isJsonArray()) {
                    this.append(builder, element.getAsJsonArray(), depth + 1);
                    continue;
                }
                this.append(builder, element.getAsJsonObject(), depth + 1);
            }
            return true;
        }

        private boolean append(StringBuilder builder, JsonArray array, int depth) {
            for (JsonElement element : array) {
                for (int current = 0; current < depth; ++current) {
                    builder.append(this.CHARS[2]);
                }
                builder.append(this.CHARS[4]);
                builder.append(this.CHARS[0]);
                if (element == null || element.isJsonNull()) {
                    builder.append("null");
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    builder.append(element.getAsString());
                    continue;
                }
                builder.append("==>");
                builder.append(this.CHARS[3]);
                if (element.isJsonArray()) {
                    this.append(builder, element.getAsJsonArray(), depth + 1);
                    continue;
                }
                this.append(builder, element.getAsJsonObject(), depth + 1);
            }
            return true;
        }
    };

    public String process(JsonObject var1);
}

