/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.net.http.ContentDeserializer;
import com.syntaxphoenix.syntaxapi.net.http.ContentSerializer;
import com.syntaxphoenix.syntaxapi.net.http.ContentToUrlModifier;
import java.net.URL;

public enum ContentType {
    X_WWW_FORM_URLENCODED(ContentSerializer.URL_ENCODED, ContentDeserializer.URL_ENCODED, ContentToUrlModifier.URL_ENCODED),
    PLAIN(ContentSerializer.PLAIN, ContentDeserializer.PLAIN),
    JSON(ContentSerializer.JSON, ContentDeserializer.JSON),
    CUSTOM;

    private ContentSerializer serializer;
    private ContentDeserializer deserializer;
    private ContentToUrlModifier urlModifier;

    private ContentType(ContentSerializer serializer, ContentDeserializer deserializer, ContentToUrlModifier urlModifier) {
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.urlModifier = urlModifier;
    }

    private ContentType(ContentSerializer serializer, ContentDeserializer deserializer) {
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    private ContentType() {
    }

    public boolean supportsUrlModification() {
        return this.urlModifier != null;
    }

    public String type() {
        return "application/" + this.name().toLowerCase();
    }

    public void modifyUrl(URL url, JsonObject object) {
        if (this.urlModifier == null) {
            return;
        }
        this.urlModifier.apply(url, object, this.serializer);
    }

    public String serialize(JsonObject object) {
        if (this.serializer == null) {
            return "";
        }
        return this.serializer.process(object);
    }

    public JsonObject deserialize(String value) {
        if (this.deserializer == null) {
            return null;
        }
        return this.deserializer.process(value);
    }

    public ContentType urlModifier(ContentToUrlModifier urlModifier) {
        if (this.urlModifier == null) {
            this.urlModifier = urlModifier;
        }
        return this;
    }

    public ContentType serializer(ContentSerializer serializer) {
        if (this.serializer == null) {
            this.serializer = serializer;
        }
        return this;
    }

    public ContentType deserializer(ContentDeserializer deserializer) {
        if (this.deserializer == null) {
            this.deserializer = deserializer;
        }
        return this;
    }

    public static ContentType fromString(String value) {
        for (ContentType type : ContentType.values()) {
            if (!type.type().equals(value)) continue;
            return type;
        }
        return CUSTOM;
    }
}

